/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.commons.proto;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import tech.bitstwinkle.jelly.commons.errors.JellyError;
import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.SystemErrorEnum;
import tech.bitstwinkle.jelly.commons.proto.Meta;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = -4989969116461765906L;
    private Meta meta;
    private boolean success;
    private JellyError error;
    private T data;

    public Response() {
    }

    public Response(JellyError error) {
        this.success = false;
        this.error = error;
    }

    public Response(T data) {
        this.success = true;
        this.data = data;
    }

    public static void assertSuccess(Response response) {
        if (response == null) {
            throw new JellyException(SystemErrorEnum.NPE_ERROR.getError("response"));
        }
        if (!response.isSuccess()) {
            throw new JellyException(response.getError());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("success", this.success).add("error", (Object)this.error).add("data", this.data).toString();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public JellyError getError() {
        return this.error;
    }

    public void setError(JellyError error) {
        this.error = error;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }
}

