/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.commons.money;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.SystemErrorEnum;

public final class MoneyHelper {
    public static String DEFAULT_CURRENCY = "CNY";
    public static BigDecimal ZERO = new BigDecimal(0L);

    public static boolean isValidCurrency(String currencyCode) {
        try {
            Currency.getInstance(currencyCode);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static boolean greaterThan(BigDecimal valA, BigDecimal valB) {
        return valA.compareTo(valB) > 0;
    }

    public static boolean equals(BigDecimal valA, BigDecimal valB) {
        return valA.compareTo(valB) == 0;
    }

    public static BigDecimal add(BigDecimal valA, BigDecimal valB) {
        return valA.add(valB).setScale(4, RoundingMode.HALF_UP);
    }

    public static BigDecimal add(BigDecimal valA, BigDecimal valB, int scale) {
        return valA.add(valB).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal minus(BigDecimal valA, BigDecimal valB) {
        return valA.add(valB.negate()).setScale(4, RoundingMode.HALF_UP);
    }

    public static BigDecimal minus(BigDecimal valA, BigDecimal valB, int scale) {
        return valA.add(valB.negate()).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(BigDecimal valA, BigDecimal valB) {
        return valA.multiply(valB).setScale(4, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(BigDecimal valA, BigDecimal valB, int scale) {
        return valA.multiply(valB).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal valA, BigDecimal valB) {
        if (BigDecimal.ZERO.compareTo(valB) == 0) {
            throw new ArithmeticException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
        }
        return valA.divide(valB, 4, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal valA, BigDecimal valB, int scale) {
        if (BigDecimal.ZERO.compareTo(valB) == 0) {
            throw new ArithmeticException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
        }
        return valA.divide(valB, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal toBigDecimal(String val) {
        if (val == null || "".equals(val.trim())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(val);
    }

    public static long toCent(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new JellyException(SystemErrorEnum.NPE_ERROR.getError("bigDecimal"));
        }
        return MoneyHelper.multiply(bigDecimal, new BigDecimal(100)).longValue();
    }
}

