/*
 * Decompiled with CFR 0.152.
 */
package tech.bitstwinkle.jelly.commons.asserts;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import tech.bitstwinkle.jelly.commons.errors.JellyException;
import tech.bitstwinkle.jelly.commons.errors.enums.ParameterErrorEnum;

public final class RequestAssert {
    public static void notNull(Object para, String name) throws JellyException {
        if (para == null) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_MISS_ERROR.getError(name));
        }
    }

    public static void notBlank(String para, String name) throws JellyException {
        if (StringUtils.isBlank((CharSequence)para)) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_MISS_ERROR.getError(name));
        }
    }

    public static void notEmpty(Collection<?> col, String name) throws JellyException {
        if (CollectionUtils.isEmpty(col)) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_MISS_ERROR.getError(name));
        }
    }

    public static void notEmpty(Map<?, ?> map, String name) throws JellyException {
        if (MapUtils.isEmpty(map)) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_MISS_ERROR.getError(name));
        }
    }

    public static void notEmpty(Object[] col, String name) throws JellyException {
        if (col == null || col.length == 0) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_MISS_ERROR.getError(name));
        }
    }

    public static void isTrue(boolean cond, String name) throws JellyException {
        if (!cond) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_INVALID_ERROR.getError(name));
        }
    }

    public static void isMobile(String input, String errorMsg) throws JellyException {
        if (input.length() != 11) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_FORMAT_ERROR.getError(errorMsg));
        }
        String phoneRegex = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(16[0,5,6])|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[1|3|8|9]))\\d{8}$";
        Pattern pattern = Pattern.compile(phoneRegex);
        if (!pattern.matcher(input).matches()) {
            throw new JellyException(ParameterErrorEnum.PARAMETER_FORMAT_ERROR.getError(errorMsg));
        }
    }
}

