/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.springboot.datacleanup.config;

import com.commercetools.api.client.ProjectApiRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import tech.bison.datacleanup.core.DataCleanup;
import tech.bison.datacleanup.core.api.command.CleanableResourceType;
import tech.bison.datacleanup.core.api.configuration.DataCleanupPredicate;
import tech.bison.springboot.datacleanup.config.DataCleanupConfig;
import tech.bison.springboot.datacleanup.config.DataCleanupPredicateConfig;

@AutoConfiguration
@EnableConfigurationProperties(value={DataCleanupConfig.class})
public class SpringBootDataCleanupAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={DataCleanup.class})
    public DataCleanup dataCleanup(ProjectApiRoot projectApiRoot, DataCleanupConfig dataCleanupConfig) {
        EnumMap typedDefinitions = new EnumMap(CleanableResourceType.class);
        if (dataCleanupConfig.getPredicates() != null) {
            dataCleanupConfig.getPredicates().forEach((key, value) -> this.addDataCleanupPredicate(typedDefinitions, (String)key, (DataCleanupPredicateConfig)value));
        }
        ArrayList<String> classes = new ArrayList<String>();
        if (dataCleanupConfig.getClasses() != null) {
            classes.addAll(dataCleanupConfig.getClasses());
        }
        return DataCleanup.configure().withPredicates(typedDefinitions).withCustomCommands(classes.toArray(new String[0])).withApiRoot(projectApiRoot).load();
    }

    private void addDataCleanupPredicate(Map<CleanableResourceType, DataCleanupPredicate> typedDefinitions, String type, DataCleanupPredicateConfig predicateConfig) {
        CleanableResourceType cleanableResourceType = Arrays.stream(CleanableResourceType.values()).filter(e -> e.getName().equals(type)).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("Unsupported resource type %s", type)));
        if (cleanableResourceType == CleanableResourceType.CUSTOM_OBJECT && StringUtils.isBlank((CharSequence)predicateConfig.container())) {
            throw new UnsupportedOperationException("Predicate of type custom-object must define a container.");
        }
        typedDefinitions.put(cleanableResourceType, new DataCleanupPredicate(predicateConfig.container(), predicateConfig.where()));
    }
}

