/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.springboot.datacleanup.config;

import com.commercetools.api.client.ProjectApiRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import tech.bison.datacleanup.core.DataCleanup;
import tech.bison.datacleanup.core.api.command.CleanableResourceType;
import tech.bison.springboot.datacleanup.config.DataCleanupConfig;

@AutoConfiguration
@EnableConfigurationProperties(value={DataCleanupConfig.class})
public class SpringBootDataCleanupAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={DataCleanup.class})
    public DataCleanup dataCleanup(ProjectApiRoot projectApiRoot, DataCleanupConfig dataCleanupConfig) {
        HashMap typedPredicates = new HashMap();
        if (dataCleanupConfig.getPredicates() != null) {
            dataCleanupConfig.getPredicates().forEach((key, value) -> typedPredicates.put(Arrays.stream(CleanableResourceType.values()).filter(e -> e.getName().equals(key)).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("Unsupported resource type %s", key))), value));
        }
        ArrayList<String> classes = new ArrayList<String>();
        if (dataCleanupConfig.getClasses() != null) {
            classes.addAll(dataCleanupConfig.getClasses());
        }
        return DataCleanup.configure().withPredicates(typedPredicates).withCustomCommands(classes.toArray(new String[0])).withApiRoot(projectApiRoot).load();
    }
}

