/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.internal.util;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativeDateTimeParser {
    private static final Pattern datePattern = Pattern.compile("\\{\\{now(\\s*[+-]\\d+[yMdhms])*\\s*}}");
    private static final Pattern diffPattern = Pattern.compile("[+-]\\d+[yMdhms]");
    private final LocalDateTime now;

    public RelativeDateTimeParser() {
        this(Clock.fixed(Instant.now(), ZoneId.systemDefault()));
    }

    public RelativeDateTimeParser(Clock clock) {
        this.now = LocalDateTime.now(clock);
    }

    public LocalDateTime parse(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Input must not be null or empty.");
        }
        Matcher matcher = datePattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Pattern '%s' has not correct format.", input));
        }
        LocalDateTime result = this.now;
        Matcher diffMatcher = diffPattern.matcher(input);
        while (diffMatcher.find()) {
            String diff = diffMatcher.group();
            int amountLength = diff.length() - 1;
            TemporalUnit unit = RelativeDateTimeParser.resolveUnit(diff.charAt(amountLength));
            long amount = Long.parseLong(diff.substring(0, amountLength));
            result = result.plus(amount, unit);
        }
        return result;
    }

    private static TemporalUnit resolveUnit(char unit) {
        return switch (unit) {
            case 'y' -> ChronoUnit.YEARS;
            case 'M' -> ChronoUnit.MONTHS;
            case 'd' -> ChronoUnit.DAYS;
            case 'h' -> ChronoUnit.HOURS;
            case 'm' -> ChronoUnit.MINUTES;
            case 's' -> ChronoUnit.SECONDS;
            default -> throw new UnsupportedOperationException(String.format("Invalid time unit '%s'. Supported units are: yMdhms.", Character.valueOf(unit)));
        };
    }
}

