/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.internal.resolver;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bison.datacleanup.core.api.command.CleanableResourceType;
import tech.bison.datacleanup.core.api.command.CleanupCommand;
import tech.bison.datacleanup.core.api.configuration.Configuration;
import tech.bison.datacleanup.core.api.configuration.DataCleanupPredicate;
import tech.bison.datacleanup.core.api.exception.DataCleanupException;
import tech.bison.datacleanup.core.internal.command.CartCommand;
import tech.bison.datacleanup.core.internal.command.CategoryCommand;
import tech.bison.datacleanup.core.internal.command.CustomObjectCommand;
import tech.bison.datacleanup.core.internal.command.OrderCommand;
import tech.bison.datacleanup.core.internal.command.ProductCommand;
import tech.bison.datacleanup.core.internal.util.RelativeDateTimeParser;

public class CleanupCommandResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupCommandResolver.class);
    private static final Pattern predicateReplacePattern = Pattern.compile("\\{\\{(.*)}}");
    private final Configuration configuration;
    private final RelativeDateTimeParser dateTimeParser;

    public CleanupCommandResolver(Configuration configuration) {
        this.configuration = configuration;
        this.dateTimeParser = configuration.getClock() != null ? new RelativeDateTimeParser(configuration.getClock()) : new RelativeDateTimeParser();
    }

    public List<CleanupCommand> getCommands() {
        ArrayList<CleanupCommand> cleanupCommands = new ArrayList<CleanupCommand>();
        block7: for (Map.Entry<CleanableResourceType, DataCleanupPredicate> entry : this.configuration.getPredicates().entrySet()) {
            DataCleanupPredicate cleanupPredicate = entry.getValue();
            switch (entry.getKey()) {
                case CUSTOM_OBJECT: {
                    cleanupCommands.add(new CustomObjectCommand(cleanupPredicate.container(), this.parsePredicates(cleanupPredicate.whereClauses())));
                    continue block7;
                }
                case CATEGORY: {
                    cleanupCommands.add(new CategoryCommand(this.parsePredicates(cleanupPredicate.whereClauses())));
                    continue block7;
                }
                case ORDER: {
                    cleanupCommands.add(new OrderCommand(this.parsePredicates(cleanupPredicate.whereClauses())));
                    continue block7;
                }
                case CART: {
                    cleanupCommands.add(new CartCommand(this.parsePredicates(cleanupPredicate.whereClauses())));
                    continue block7;
                }
                case PRODUCT: {
                    cleanupCommands.add(new ProductCommand(this.parsePredicates(cleanupPredicate.whereClauses())));
                    continue block7;
                }
            }
            LOG.warn("Unsupported predicate type '{}'.", (Object)entry.getKey());
        }
        this.configuration.getCustomCommandClasses().forEach(c -> cleanupCommands.add(this.createCommand((String)c)));
        return cleanupCommands;
    }

    private CleanupCommand createCommand(String clazz) {
        try {
            return (CleanupCommand)Class.forName(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DataCleanupException("Unable to instantiate class " + clazz + " : " + e.getMessage(), e);
        }
    }

    private List<String> parsePredicates(List<String> predicates) {
        return predicates.stream().map(this::parsePredicate).toList();
    }

    private String parsePredicate(String predicate) {
        Matcher matcher = predicateReplacePattern.matcher(predicate);
        return matcher.replaceAll(match -> this.dateTimeParser.parse(match.group()).format(DateTimeFormatter.ISO_DATE_TIME));
    }
}

