/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.internal.command;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.ResourcePagedQueryResponse;
import com.commercetools.api.models.custom_object.CustomObject;
import java.util.List;
import java.util.Objects;
import tech.bison.datacleanup.core.api.command.CleanableResourceType;
import tech.bison.datacleanup.core.internal.command.BaseCleanupCommand;

public class CustomObjectCommand
extends BaseCleanupCommand<CustomObject> {
    private final String container;

    public CustomObjectCommand(String container, List<String> predicates) {
        super(predicates);
        this.container = Objects.requireNonNull(container);
    }

    @Override
    protected ResourcePagedQueryResponse<CustomObject> getResourcesToDelete(ProjectApiRoot projectApiRoot) {
        return (ResourcePagedQueryResponse)projectApiRoot.customObjects().withContainer(this.container).get().withLimit((Object)BaseCleanupCommand.QUERY_RESULT_LIMIT).withWhere(this.getPredicates()).executeBlocking().getBody();
    }

    @Override
    protected CustomObject delete(ProjectApiRoot projectApiRoot, CustomObject resource) {
        return (CustomObject)projectApiRoot.customObjects().withContainerAndKey(resource.getContainer(), resource.getKey()).delete().executeBlocking().getBody();
    }

    @Override
    public CleanableResourceType getResourceType() {
        return CleanableResourceType.CUSTOM_OBJECT;
    }
}

