/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.internal.command;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.ResourcePagedQueryResponse;
import com.commercetools.api.models.common.BaseResource;
import io.vrap.rmf.base.client.ApiHttpException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bison.datacleanup.core.api.command.CleanupCommand;
import tech.bison.datacleanup.core.api.command.ResourceCleanupSummary;
import tech.bison.datacleanup.core.api.executor.Context;

public abstract class BaseCleanupCommand<T extends BaseResource>
implements CleanupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCleanupCommand.class);
    static final Long QUERY_RESULT_LIMIT = 100L;
    private final List<String> predicates;

    protected BaseCleanupCommand(List<String> predicates) {
        this.predicates = predicates;
    }

    protected List<String> getPredicates() {
        return this.predicates;
    }

    protected abstract ResourcePagedQueryResponse<T> getResourcesToDelete(ProjectApiRoot var1);

    protected abstract T delete(ProjectApiRoot var1, T var2);

    @Override
    public ResourceCleanupSummary execute(Context context) {
        ResourcePagedQueryResponse<T> queryResponse = this.getResourcesToDelete(context.getProjectApiRoot());
        LOG.info("Found {} resources ({}) to be deleted.", (Object)queryResponse.getCount(), (Object)this.getResourceType().getName());
        ArrayList<String> deletedObjectsIds = new ArrayList<String>();
        for (BaseResource customObject : queryResponse.getResults()) {
            try {
                BaseResource response = this.delete(context.getProjectApiRoot(), customObject);
                LOG.info("Deleted {} with id '{}' and version '{}'.", new Object[]{this.getResourceType().getName(), response.getId(), response.getVersion()});
                deletedObjectsIds.add(customObject.getId());
            }
            catch (ApiHttpException exception) {
                LOG.error("Failed to delete {} with id '{}'.", new Object[]{this.getResourceType().getName(), customObject.getId(), exception});
            }
        }
        return new ResourceCleanupSummary(deletedObjectsIds.size());
    }
}

