/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.api.executor;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bison.datacleanup.core.api.command.CleanupCommand;
import tech.bison.datacleanup.core.api.command.CleanupResult;
import tech.bison.datacleanup.core.api.command.ResourceCleanupSummary;
import tech.bison.datacleanup.core.api.executor.Context;

public class DataCleanupExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DataCleanupExecutor.class);

    public CleanupResult execute(Context context, List<CleanupCommand> cleanupCommands) {
        CleanupResult cleanupResult = CleanupResult.empty();
        for (CleanupCommand cleanupCommand : cleanupCommands) {
            LOG.info("Running data cleanup for resource '{}'.", (Object)cleanupCommand.getResourceType().getName());
            ResourceCleanupSummary resourceCleanupSummary = cleanupCommand.execute(context);
            cleanupResult.addResult(cleanupCommand.getResourceType(), resourceCleanupSummary);
        }
        return cleanupResult;
    }
}

