/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core.api.configuration;

import com.commercetools.api.client.ProjectApiRoot;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import tech.bison.datacleanup.core.DataCleanup;
import tech.bison.datacleanup.core.api.command.CleanableResourceType;
import tech.bison.datacleanup.core.api.configuration.CommercetoolsProperties;
import tech.bison.datacleanup.core.api.configuration.Configuration;
import tech.bison.datacleanup.core.api.configuration.DataCleanupPredicate;
import tech.bison.datacleanup.core.api.exception.DataCleanupException;

public class FluentConfiguration
implements Configuration {
    private CommercetoolsProperties apiProperties;
    private ProjectApiRoot projectApiRoot;
    private final Map<CleanableResourceType, DataCleanupPredicate> predicates = new EnumMap<CleanableResourceType, DataCleanupPredicate>(CleanableResourceType.class);
    private final List<String> customCommandClasses = new ArrayList<String>();
    private Clock clock;

    public DataCleanup load() {
        this.validateConfiguration();
        return new DataCleanup(this);
    }

    private void validateConfiguration() {
        if (this.projectApiRoot == null && this.apiProperties == null) {
            throw new DataCleanupException("Missing commercetools import api configuration. Either use withApiProperties() or withApiRoot().");
        }
    }

    public FluentConfiguration withApiProperties(CommercetoolsProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public FluentConfiguration withApiRoot(ProjectApiRoot projectApiRoot) {
        this.projectApiRoot = projectApiRoot;
        return this;
    }

    public FluentConfiguration withPredicates(Map<CleanableResourceType, DataCleanupPredicate> predicates) {
        this.predicates.putAll(predicates);
        return this;
    }

    public FluentConfiguration withCustomCommands(String ... fullQualifiedClassNames) {
        this.customCommandClasses.addAll(Arrays.stream(fullQualifiedClassNames).toList());
        return this;
    }

    public FluentConfiguration withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public CommercetoolsProperties getApiProperties() {
        return this.apiProperties;
    }

    @Override
    public ProjectApiRoot getApiRoot() {
        return this.projectApiRoot;
    }

    @Override
    public Map<CleanableResourceType, DataCleanupPredicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public List<String> getCustomCommandClasses() {
        return this.customCommandClasses;
    }
}

