/*
 * Decompiled with CFR 0.152.
 */
package tech.bison.datacleanup.core;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.bison.datacleanup.core.api.command.CleanupCommand;
import tech.bison.datacleanup.core.api.command.CleanupResult;
import tech.bison.datacleanup.core.api.configuration.Configuration;
import tech.bison.datacleanup.core.api.configuration.FluentConfiguration;
import tech.bison.datacleanup.core.api.exception.DataCleanupException;
import tech.bison.datacleanup.core.api.executor.Context;
import tech.bison.datacleanup.core.api.executor.DataCleanupExecutor;
import tech.bison.datacleanup.core.internal.resolver.CleanupCommandResolver;

public class DataCleanup {
    private static final Logger LOG = LoggerFactory.getLogger(DataCleanup.class);
    private final Configuration configuration;
    private final CleanupCommandResolver commandResolver;
    private final DataCleanupExecutor dataCleanupExecutor;

    public DataCleanup(Configuration configuration) {
        this.configuration = configuration;
        this.commandResolver = new CleanupCommandResolver(configuration);
        this.dataCleanupExecutor = new DataCleanupExecutor();
    }

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public CleanupResult execute() {
        try {
            Context context = new Context(this.configuration);
            List<CleanupCommand> cleanupCommands = this.commandResolver.getCommands();
            if (cleanupCommands.isEmpty()) {
                LOG.info("No cleanup commands found.");
                return CleanupResult.empty();
            }
            return this.dataCleanupExecutor.execute(context, cleanupCommands);
        }
        catch (Exception ex) {
            throw new DataCleanupException("Error while executing data cleanup.", ex);
        }
    }
}

