/*
 * Decompiled with CFR 0.152.
 */
package tech.bilal.embedded_keycloak.impl.download;

import akka.Done;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import os.exists$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import tech.bilal.embedded_keycloak.Settings;
import tech.bilal.embedded_keycloak.impl.FileIO;
import tech.bilal.embedded_keycloak.impl.download.DownloadProgress;
import tech.bilal.embedded_keycloak.impl.download.Downloader;
import tech.bilal.embedded_keycloak.impl.download.DownloaderExtensions$;

@ScalaSignature(bytes="\u0006\u0001\u00153Q\u0001C\u0005\u0001\u001bMA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006I\u0001!\t!\n\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u0011\u0019q\u0003\u0001)A\u0005U!)q\u0006\u0001C\u0005a!)A\b\u0001C\u0005{!)!\u0002\u0001C\u0001\u0003\nq\u0011i[6b\t><h\u000e\\8bI\u0016\u0014(B\u0001\u0006\f\u0003!!wn\u001e8m_\u0006$'B\u0001\u0007\u000e\u0003\u0011IW\u000e\u001d7\u000b\u00059y\u0011!E3nE\u0016$G-\u001a3`W\u0016L8\r\\8bW*\u0011\u0001#E\u0001\u0006E&d\u0017\r\u001c\u0006\u0002%\u0005!A/Z2i'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"A\u0005\n\u0005uI!A\u0003#po:dw.\u00193fe\u0006A1/\u001a;uS:<7o\u0001\u0001\u0011\u0005\u0005\u0012S\"A\u0007\n\u0005\rj!\u0001C*fiRLgnZ:\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u001c\u0001!)aD\u0001a\u0001A\u00051a-\u001b7f\u0013>+\u0012A\u000b\t\u0003W1j\u0011aC\u0005\u0003[-\u0011aAR5mK&{\u0015a\u00024jY\u0016Lu\nI\u0001\u0007O\u0016$XK\u001d7\u0016\u0003E\u0002\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u0017\u001b\u0005)$B\u0001\u001c \u0003\u0019a$o\\8u}%\u0011\u0001HF\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029-\u0005!\u0012n]&fs\u000edw.Y6E_^tGn\\1eK\u0012,\u0012A\u0010\t\u0003+}J!\u0001\u0011\f\u0003\u000f\t{w\u000e\\3b]R\t!\t\u0005\u0002\u0016\u0007&\u0011AI\u0006\u0002\u0005+:LG\u000f")
public class AkkaDownloader
implements Downloader {
    private final Settings settings;
    private final FileIO fileIO;

    public FileIO fileIO() {
        return this.fileIO;
    }

    private String getUrl() {
        return new StringBuilder(66).append("https://downloads.jboss.org/keycloak/").append(this.settings.version()).append(".Final/keycloak-").append(this.settings.version()).append(".Final.tar.gz").toString();
    }

    private boolean isKeycloakDownloaded() {
        return exists$.MODULE$.apply(this.fileIO().tarFilePath());
    }

    @Override
    public void download() {
        block0: {
            if (!this.settings.alwaysDownload() && this.isKeycloakDownloaded()) break block0;
            Predef$.MODULE$.println((Object)"downloading keycloak...");
            this.fileIO().deleteVersion();
            Config config = ConfigFactory.load().withValue("akka.loglevel", ConfigValueFactory.fromAnyRef((Object)"OFF")).withValue("akka.stdout-loglevel", ConfigValueFactory.fromAnyRef((Object)"OFF"));
            ActorSystem actorSystem = ActorSystem$.MODULE$.apply("download-actor-system", config);
            ExecutionContextExecutor ec = actorSystem.dispatcher();
            ActorMaterializer materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)actorSystem);
            HttpExt qual$1 = Http$.MODULE$.apply(actorSystem);
            Uri x$12 = Uri$.MODULE$.apply(this.getUrl());
            HttpMethod x$2 = HttpRequest$.MODULE$.apply$default$1();
            Seq x$3 = HttpRequest$.MODULE$.apply$default$3();
            RequestEntity x$4 = HttpRequest$.MODULE$.apply$default$4();
            HttpProtocol x$5 = HttpRequest$.MODULE$.apply$default$5();
            HttpRequest x$6 = HttpRequest$.MODULE$.apply(x$2, x$12, x$3, x$4, x$5);
            HttpsConnectionContext x$7 = qual$1.singleRequest$default$2();
            ConnectionPoolSettings x$8 = qual$1.singleRequest$default$3();
            LoggingAdapter x$9 = qual$1.singleRequest$default$4();
            Future responseFuture = qual$1.singleRequest(x$6, x$7, x$8, x$9);
            Future contentLength = responseFuture.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)AkkaDownloader.$anonfun$download$1(x0$1)), (ExecutionContext)ec);
            Source<DownloadProgress, Future<Done>> source = DownloaderExtensions$.MODULE$.ProgressSource(DownloaderExtensions$.MODULE$.ProgressSource(DownloaderExtensions$.MODULE$.ProgressSource(DownloaderExtensions$.MODULE$.RichByteStringSourceOfDone(DownloaderExtensions$.MODULE$.RichHttpResponseFuture((Future<HttpResponse>)responseFuture, (ExecutionContext)ec).toByteStringSource()).toProgressSource((Future<Object>)contentLength, (ExecutionContext)ec)).writeToFile(this.fileIO().incompleteTarFilePath(), (ExecutionContext)ec)).untilDownloadCompletes()).compressForPrinting();
            Future materializedValue = source.runForeach((Function1 & Serializable & scala.Serializable)progress -> {
                Predef$.MODULE$.print((Object)new StringBuilder(1).append("\r").append(progress).toString());
                return BoxedUnit.UNIT;
            }, (Materializer)materializer);
            materializedValue.onComplete((Function1 & Serializable & scala.Serializable)x$1 -> {
                AkkaDownloader.$anonfun$download$4(this, actorSystem, x$1);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ec);
            Await$.MODULE$.result((Awaitable)materializedValue, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).minutes());
        }
    }

    public static final /* synthetic */ long $anonfun$download$1(HttpResponse x0$1) {
        ResponseEntity entity;
        block5: {
            HttpResponse httpResponse;
            HttpResponse httpResponse2;
            block4: {
                httpResponse2 = x0$1;
                HttpResponse httpResponse3 = HttpResponse$.MODULE$.unapply(httpResponse2);
                if (OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse3)) break block4;
                StatusCode statusCode = httpResponse3._1();
                entity = httpResponse3._3();
                StatusCodes.Success success = StatusCodes$.MODULE$.OK();
                StatusCode statusCode2 = statusCode;
                if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) break block5;
            }
            if (!OptHttpResponse$.MODULE$.isEmpty$extension(httpResponse = HttpResponse$.MODULE$.unapply(httpResponse2))) {
                StatusCode statusCode = httpResponse._1();
                throw new RuntimeException(new StringBuilder(45).append("ERROR: error while downloading. status code: ").append(statusCode).toString());
            }
            throw new MatchError((Object)httpResponse2);
        }
        long l = BoxesRunTime.unboxToLong((Object)entity.contentLengthOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("content length is not provided");
        }));
        return l;
    }

    public static final /* synthetic */ void $anonfun$download$4(AkkaDownloader $this, ActorSystem actorSystem$1, Try x$1) {
        actorSystem$1.terminate();
        $this.fileIO().moveIncompleteFile();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"keycloak downloaded");
    }

    public AkkaDownloader(Settings settings) {
        this.settings = settings;
        this.fileIO = new FileIO(settings);
    }
}

