/*
 * Decompiled with CFR 0.152.
 */
package tech.bilal.embedded_keycloak.impl;

import os.Path;
import os.Path$;
import os.PathConvertible;
import os.RelPath$;
import os.exists$;
import os.makeDir;
import os.remove;
import scala.reflect.ScalaSignature;
import tech.bilal.embedded_keycloak.KeycloakData;
import tech.bilal.embedded_keycloak.Settings;
import tech.bilal.embedded_keycloak.impl.Bash$;
import tech.bilal.embedded_keycloak.impl.data.AdminFeeder;
import tech.bilal.embedded_keycloak.impl.download.CurlDownloader;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0004\t\u00013!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u001dy\u0003A1A\u0005\u0002ABaa\u000e\u0001!\u0002\u0013\t\u0004b\u0002\u001d\u0001\u0005\u0004%\t!\u000f\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001e\t\u000b\u0001\u0003A\u0011B!\t\u000b!\u0003A\u0011B!\t\u000b%\u0003A\u0011B!\t\u000b)\u0003A\u0011B&\t\u000b=\u0003A\u0011\u0002)\t\u000bQ\u0003A\u0011B&\t\u000bU\u0003A\u0011A&\u0003\u0013%s7\u000f^1mY\u0016\u0014(BA\t\u0013\u0003\u0011IW\u000e\u001d7\u000b\u0005M!\u0012!E3nE\u0016$G-\u001a3`W\u0016L8\r\\8bW*\u0011QCF\u0001\u0006E&d\u0017\r\u001c\u0006\u0002/\u0005!A/Z2i\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003!\u0019X\r\u001e;j]\u001e\u001c\bC\u0001\u0012$\u001b\u0005\u0011\u0012B\u0001\u0013\u0013\u0005!\u0019V\r\u001e;j]\u001e\u001c\u0018\u0001\u00023bi\u0006\u0004\"AI\u0014\n\u0005!\u0012\"\u0001D&fs\u000edw.Y6ECR\f\u0017A\u0002\u001fj]&$h\bF\u0002,[9\u0002\"\u0001\f\u0001\u000e\u0003AAQ\u0001I\u0002A\u0002\u0005BQ!J\u0002A\u0002\u0019\n!\u0002Z8x]2|\u0017\rZ3s+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003!!wn\u001e8m_\u0006$\u0017B\u0001\u001c4\u00059\u0019UO\u001d7E_^tGn\\1eKJ\f1\u0002Z8x]2|\u0017\rZ3sA\u0005Y\u0011\rZ7j]\u001a+W\rZ3s+\u0005Q\u0004CA\u001e>\u001b\u0005a$BA\u0013\u0011\u0013\tqDHA\u0006BI6LgNR3fI\u0016\u0014\u0018\u0001D1e[&tg)Z3eKJ\u0004\u0013aD4fi.+\u0017p\u00197pC.\u0014vn\u001c;\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0003_NL!a\u0012#\u0003\tA\u000bG\u000f[\u0001\u0010O\u0016$()\u001b8ESJ,7\r^8ss\u0006qq-\u001a;UCJ4\u0015\u000e\\3QCRD\u0017!E2mK\u0006t\u0017J\\:uC2d\u0017\r^5p]R\tA\n\u0005\u0002\u001c\u001b&\u0011a\n\b\u0002\u0005+:LG/A\njg.+\u0017p\u00197pC.Len\u001d;bY2,G-F\u0001R!\tY\"+\u0003\u0002T9\t9!i\\8mK\u0006t\u0017A\u00033fG>l\u0007O]3tg\u00069\u0011N\\:uC2d\u0007")
public class Installer {
    private final Settings settings;
    private final KeycloakData data;
    private final CurlDownloader downloader;
    private final AdminFeeder adminFeeder;

    public CurlDownloader downloader() {
        return this.downloader;
    }

    public AdminFeeder adminFeeder() {
        return this.adminFeeder;
    }

    private Path getKeycloakRoot() {
        return Path$.MODULE$.apply((Object)this.settings.installationDirectory(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$).$div(RelPath$.MODULE$.StringPath(this.settings.version())).$div(RelPath$.MODULE$.StringPath("binaries"));
    }

    private Path getBinDirectory() {
        return this.getKeycloakRoot().$div(RelPath$.MODULE$.StringPath(new StringBuilder(15).append("keycloak-").append(this.settings.version()).append(".Final").toString())).$div(RelPath$.MODULE$.StringPath("bin"));
    }

    private Path getTarFilePath() {
        return Path$.MODULE$.apply((Object)this.settings.installationDirectory(), (PathConvertible)PathConvertible.StringConvertible$.MODULE$).$div(RelPath$.MODULE$.StringPath(this.settings.version())).$div(RelPath$.MODULE$.StringPath(new StringBuilder(22).append("keycloak-").append(this.settings.version()).append(".Final.tar.gz").toString()));
    }

    private void cleanInstallation() {
        block0: {
            if (!exists$.MODULE$.apply(this.getKeycloakRoot())) break block0;
            remove.all$.MODULE$.apply(this.getKeycloakRoot());
        }
    }

    private boolean isKeycloakInstalled() {
        Path wd = this.getBinDirectory().$div(RelPath$.MODULE$.StringPath("standalone.sh"));
        return exists$.MODULE$.apply(wd);
    }

    private void decompress() {
        makeDir.all$.MODULE$.apply(this.getKeycloakRoot());
        Bash$.MODULE$.exec(new StringBuilder(13).append("tar -xzf ").append(this.getTarFilePath()).append(" -C ").append(this.getKeycloakRoot()).toString(), Bash$.MODULE$.exec$default$2());
    }

    public void install() {
        this.downloader().download();
        if (this.settings.cleanPreviousData() || !this.isKeycloakInstalled()) {
            this.cleanInstallation();
            this.decompress();
        }
        this.adminFeeder().feedAdminUser(this.data.adminUser());
    }

    public Installer(Settings settings, KeycloakData data) {
        this.settings = settings;
        this.data = data;
        this.downloader = new CurlDownloader(settings);
        this.adminFeeder = new AdminFeeder(settings);
    }
}

