/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.services;

import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.CreateTokenRequest;
import tech.aroma.thrift.authentication.service.CreateTokenResponse;
import tech.aroma.thrift.authentication.service.GetTokenInfoRequest;
import tech.aroma.thrift.authentication.service.GetTokenInfoResponse;
import tech.aroma.thrift.authentication.service.InvalidateTokenRequest;
import tech.aroma.thrift.authentication.service.InvalidateTokenResponse;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.authentication.service.VerifyTokenResponse;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.ArgumentsKtKt;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.thrift.clients.Clients;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/aroma/thrift/services/PerRequestAuthenticationService;", "Ltech/aroma/thrift/authentication/service/AuthenticationService$Iface;", "clientProvider", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "createToken", "Ltech/aroma/thrift/authentication/service/CreateTokenResponse;", "request", "Ltech/aroma/thrift/authentication/service/CreateTokenRequest;", "getApiVersion", "", "getTokenInfo", "Ltech/aroma/thrift/authentication/service/GetTokenInfoResponse;", "Ltech/aroma/thrift/authentication/service/GetTokenInfoRequest;", "invalidateToken", "Ltech/aroma/thrift/authentication/service/InvalidateTokenResponse;", "Ltech/aroma/thrift/authentication/service/InvalidateTokenRequest;", "verifyToken", "Ltech/aroma/thrift/authentication/service/VerifyTokenResponse;", "Ltech/aroma/thrift/authentication/service/VerifyTokenRequest;", "Companion", "aroma-thrift"})
@Internal
@ThreadSafe
@DecoratorPattern(role=DecoratorPattern.Role.DECORATOR)
public final class PerRequestAuthenticationService
implements AuthenticationService.Iface {
    private final Callable<AuthenticationService.Iface> clientProvider;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getApiVersion() throws TException {
        AuthenticationService.Iface client = this.clientProvider.call();
        try {
            AuthenticationService.Iface iface = client;
            Intrinsics.checkExpressionValueIsNotNull((Object)iface, (String)"client");
            double d = iface.getApiVersion();
            return d;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CreateTokenResponse createToken(@NotNull CreateTokenRequest request) throws OperationFailedException, InvalidArgumentException, TException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AuthenticationService.Iface client = this.clientProvider.call();
        try {
            CreateTokenResponse createTokenResponse = client.createToken(request);
            return createTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GetTokenInfoResponse getTokenInfo(@NotNull GetTokenInfoRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AuthenticationService.Iface client = this.clientProvider.call();
        try {
            GetTokenInfoResponse getTokenInfoResponse = client.getTokenInfo(request);
            return getTokenInfoResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InvalidateTokenResponse invalidateToken(@NotNull InvalidateTokenRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AuthenticationService.Iface client = this.clientProvider.call();
        try {
            InvalidateTokenResponse invalidateTokenResponse = client.invalidateToken(request);
            return invalidateTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VerifyTokenResponse verifyToken(@NotNull VerifyTokenRequest request) throws OperationFailedException, InvalidTokenException, InvalidArgumentException, TException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AuthenticationService.Iface client = this.clientProvider.call();
        try {
            VerifyTokenResponse verifyTokenResponse = client.verifyToken(request);
            return verifyTokenResponse;
        }
        finally {
            Clients.attemptClose((Object)client);
        }
    }

    public PerRequestAuthenticationService(@NotNull Callable<AuthenticationService.Iface> clientProvider2) {
        Intrinsics.checkParameterIsNotNull(clientProvider2, (String)"clientProvider");
        this.clientProvider = clientProvider2;
        ArgumentsKtKt.checkThat(this.clientProvider).isA(Assertions.nonNullReference());
        ArgumentsKtKt.checkThat((Object)this.clientProvider.call()).usingMessage("clientProvider returned null").isA(Assertions.nonNullReference());
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(PerRequestAuthenticationService.class);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltech/aroma/thrift/services/PerRequestAuthenticationService$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "aroma-thrift"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

