/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.services;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.AuthenticationServiceConstants;
import tech.aroma.thrift.endpoint.TcpEndpoint;
import tech.aroma.thrift.notification.service.NotificationService;
import tech.aroma.thrift.notification.service.NotificationServiceConstants;
import tech.aroma.thrift.service.AromaService;
import tech.aroma.thrift.service.AromaServiceConstants;
import tech.aroma.thrift.services.Clients;
import tech.aroma.thrift.services.PerRequestAuthenticationService;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/aroma/thrift/services/Clients;", "", "()V", "Companion", "aroma-thrift"})
public final class Clients {
    private static final Logger LOG;
    public static final Companion Companion;

    private Clients() {
        throw (Throwable)new IllegalAccessException("cannot instantiate");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Clients.class);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationService.Client newAuthenticationServiceClient() throws TTransportException {
        return Companion.newAuthenticationServiceClient();
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationService.Iface newPerRequestAuthenticationServiceClient() throws TTransportException {
        return Companion.newPerRequestAuthenticationServiceClient();
    }

    @JvmStatic
    @NotNull
    public static final AromaService.Client newAromaServiceClient() throws TTransportException {
        return Companion.newAromaServiceClient();
    }

    @JvmStatic
    @NotNull
    public static final NotificationService.Client newNotificationServiceClient() throws TTransportException {
        return Companion.newNotificationServiceClient();
    }

    @JvmStatic
    private static final TProtocol tryCreateProtocolAt(TcpEndpoint endpoint, String serviceName) throws TTransportException {
        return Clients.Companion.tryCreateProtocolAt(endpoint, serviceName);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/aroma/thrift/services/Clients$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "newAromaServiceClient", "Ltech/aroma/thrift/service/AromaService$Client;", "newAuthenticationServiceClient", "Ltech/aroma/thrift/authentication/service/AuthenticationService$Client;", "newNotificationServiceClient", "Ltech/aroma/thrift/notification/service/NotificationService$Client;", "newPerRequestAuthenticationServiceClient", "Ltech/aroma/thrift/authentication/service/AuthenticationService$Iface;", "tryCreateProtocolAt", "Lorg/apache/thrift/protocol/TProtocol;", "endpoint", "Ltech/aroma/thrift/endpoint/TcpEndpoint;", "serviceName", "", "aroma-thrift"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AuthenticationService.Client newAuthenticationServiceClient() throws TTransportException {
            TcpEndpoint endpoint;
            TcpEndpoint tcpEndpoint = endpoint = AuthenticationServiceConstants.BETA_ENDPOINT;
            Intrinsics.checkExpressionValueIsNotNull((Object)tcpEndpoint, (String)"endpoint");
            TProtocol protocol = this.tryCreateProtocolAt(tcpEndpoint, "Authentication Service");
            return new AuthenticationService.Client(protocol);
        }

        @JvmStatic
        @NotNull
        public final AuthenticationService.Iface newPerRequestAuthenticationServiceClient() throws TTransportException {
            Callable clientProvider2 = newPerRequestAuthenticationServiceClient.clientProvider.1.INSTANCE;
            PerRequestAuthenticationService decorator = new PerRequestAuthenticationService(clientProvider2);
            return decorator;
        }

        @JvmStatic
        @NotNull
        public final AromaService.Client newAromaServiceClient() throws TTransportException {
            TcpEndpoint endpoint;
            TcpEndpoint tcpEndpoint = endpoint = AromaServiceConstants.BETA_ENDPOINT;
            Intrinsics.checkExpressionValueIsNotNull((Object)tcpEndpoint, (String)"endpoint");
            TProtocol protocol = this.tryCreateProtocolAt(tcpEndpoint, "Aroma Service");
            return new AromaService.Client(protocol);
        }

        @JvmStatic
        @NotNull
        public final NotificationService.Client newNotificationServiceClient() throws TTransportException {
            TcpEndpoint endpoint;
            TcpEndpoint tcpEndpoint = endpoint = NotificationServiceConstants.BETA_ENDPOINT;
            Intrinsics.checkExpressionValueIsNotNull((Object)tcpEndpoint, (String)"endpoint");
            TProtocol protocol = this.tryCreateProtocolAt(tcpEndpoint, "Notification Service");
            return new NotificationService.Client(protocol);
        }

        @JvmStatic
        private final TProtocol tryCreateProtocolAt(TcpEndpoint endpoint, String serviceName) throws TTransportException {
            long timeout = TimeUnit.SECONDS.toMillis(45L);
            TSocket transport = new TSocket(endpoint.hostname, endpoint.port, (int)timeout);
            try {
                transport.open();
            }
            catch (TTransportException ex) {
                LOG.error("Failed to connect to {} at {}", new Object[]{serviceName, endpoint, ex});
                throw (Throwable)ex;
            }
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return (TProtocol)protocol;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

