/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.functions;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.TimeUnit;
import tech.aroma.thrift.functions.TimeFunctions;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.ArgumentsKtKt;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0007J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0017\u001a\u00020\u00112\b\b\u0001\u0010\u0018\u001a\u00020\u0005H\u0007R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0019"}, d2={"Ltech/aroma/thrift/functions/TimeFunctions;", "", "()V", "LENGTH_OF_TIME_TO_DURATION", "Ljava/util/function/Function;", "Ltech/aroma/thrift/LengthOfTime;", "Ljava/time/Duration;", "LENGTH_OF_TIME_TO_DURATION$annotations", "getLENGTH_OF_TIME_TO_DURATION", "()Ljava/util/function/Function;", "TIME_UNIT_TO_CHRONO_UNIT", "Ltech/aroma/thrift/TimeUnit;", "Ljava/time/temporal/ChronoUnit;", "getTIME_UNIT_TO_CHRONO_UNIT", "isInTheFuture", "", "timestamp", "", "isInThePast", "lengthOfTimeToDuration", "timeUnitToChronoUnit", "toInstant", "Ljava/time/Instant;", "toSeconds", "lengthOfTime", "aroma-thrift"})
public final class TimeFunctions {
    @NotNull
    private static final Function<TimeUnit, ChronoUnit> TIME_UNIT_TO_CHRONO_UNIT;
    @NotNull
    private static final Function<LengthOfTime, Duration> LENGTH_OF_TIME_TO_DURATION;
    public static final TimeFunctions INSTANCE;

    @NotNull
    public final Function<TimeUnit, ChronoUnit> getTIME_UNIT_TO_CHRONO_UNIT() {
        return TIME_UNIT_TO_CHRONO_UNIT;
    }

    @JvmStatic
    @NotNull
    public static final Function<TimeUnit, ChronoUnit> timeUnitToChronoUnit() {
        return TIME_UNIT_TO_CHRONO_UNIT;
    }

    @JvmStatic
    public static /* synthetic */ void LENGTH_OF_TIME_TO_DURATION$annotations() {
    }

    @NotNull
    public static final Function<LengthOfTime, Duration> getLENGTH_OF_TIME_TO_DURATION() {
        return LENGTH_OF_TIME_TO_DURATION;
    }

    @JvmStatic
    @NotNull
    public static final Function<LengthOfTime, Duration> lengthOfTimeToDuration() {
        return LENGTH_OF_TIME_TO_DURATION;
    }

    @JvmStatic
    public static final long toSeconds(@Required @NotNull LengthOfTime lengthOfTime) {
        Duration duration;
        Intrinsics.checkParameterIsNotNull((Object)lengthOfTime, (String)"lengthOfTime");
        ArgumentsKtKt.checkThat((Object)lengthOfTime).isA(Assertions.nonNullReference());
        Duration duration2 = duration = TimeFunctions.lengthOfTimeToDuration().apply(lengthOfTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration");
        return duration2.getSeconds();
    }

    @JvmStatic
    @NotNull
    public static final Instant toInstant(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(timestamp)");
        return instant;
    }

    @JvmStatic
    public static final boolean isInThePast(long timestamp) {
        return TimeFunctions.toInstant(timestamp).isBefore(Instant.now());
    }

    @JvmStatic
    public static final boolean isInTheFuture(long timestamp) {
        return TimeFunctions.toInstant(timestamp).isAfter(Instant.now());
    }

    private TimeFunctions() {
    }

    static {
        TimeFunctions timeFunctions;
        INSTANCE = timeFunctions = new TimeFunctions();
        TIME_UNIT_TO_CHRONO_UNIT = TIME_UNIT_TO_CHRONO_UNIT.1.INSTANCE;
        LENGTH_OF_TIME_TO_DURATION = LENGTH_OF_TIME_TO_DURATION.1.INSTANCE;
    }
}

