/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.thrift.assertions;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.aroma.thrift.assertions.AromaAssertions;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.UserToken;
import tech.aroma.thrift.authentication.service.AuthenticationService;
import tech.aroma.thrift.authentication.service.VerifyTokenRequest;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.ArgumentsKtKt;
import tech.sirwellington.alchemy.arguments.ExceptionMapper;
import tech.sirwellington.alchemy.arguments.FailedAssertionException;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0017"}, d2={"Ltech/aroma/thrift/assertions/AromaAssertions;", "", "()V", "checkNotNull", "", "reference", "message", "", "checkRequestNotNull", "request", "legalToken", "Ltech/sirwellington/alchemy/arguments/AlchemyAssertion;", "Ltech/aroma/thrift/authentication/AuthenticationToken;", "validApplicationTokenIn", "Ltech/aroma/thrift/authentication/ApplicationToken;", "authenticationService", "Ltech/aroma/thrift/authentication/service/AuthenticationService$Iface;", "validTokenIn", "validUserTokenIn", "Ltech/aroma/thrift/authentication/UserToken;", "withMessage", "Ltech/sirwellington/alchemy/arguments/ExceptionMapper;", "Ltech/aroma/thrift/exceptions/InvalidArgumentException;", "aroma-thrift"})
public final class AromaAssertions {
    public static final AromaAssertions INSTANCE;

    @JvmStatic
    @NotNull
    public static final ExceptionMapper<InvalidArgumentException> withMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return (ExceptionMapper)new ExceptionMapper<InvalidArgumentException>(message){
            final /* synthetic */ String $message;

            @NotNull
            public final InvalidArgumentException apply(FailedAssertionException it) {
                return new InvalidArgumentException(this.$message);
            }
            {
                this.$message = string;
            }
        };
    }

    @JvmStatic
    public static final void checkRequestNotNull(@Nullable Object request) throws InvalidArgumentException {
        AromaAssertions.checkNotNull(request, "missing request");
    }

    @JvmStatic
    public static final void checkNotNull(@Nullable Object reference, @NotNull String message) throws InvalidArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ArgumentsKtKt.checkThat((Object)reference).throwing(AromaAssertions.withMessage(message)).isA(Assertions.nonNullReference());
    }

    @JvmStatic
    @NotNull
    public static final AlchemyAssertion<AuthenticationToken> legalToken() {
        return legalToken.1.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final AlchemyAssertion<ApplicationToken> validApplicationTokenIn(@Required @NotNull AuthenticationService.Iface authenticationService) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationService, (String)"authenticationService");
        ArgumentsKtKt.checkThat((Object)authenticationService).usingMessage("authentication service is null").isA(Assertions.notNull());
        return (AlchemyAssertion)new AlchemyAssertion<ApplicationToken>(authenticationService){
            final /* synthetic */ AuthenticationService.Iface $authenticationService;

            public final void check(ApplicationToken token) {
                ArgumentsKtKt.checkThat((Object)token).usingMessage("token is null").isA(Assertions.notNull());
                ArgumentsKtKt.checkThat((Object)token.tokenId).usingMessage("token is missing tokenId").isA(StringAssertions.nonEmptyString());
                AuthenticationToken authToken = new AuthenticationToken().setTokenId(token.tokenId).setOwnerId(token.applicationId).setOwnerName(token.applicationName);
                ArgumentsKtKt.checkThat((Object)authToken).isA(AromaAssertions.validTokenIn(this.$authenticationService));
            }
            {
                this.$authenticationService = iface;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final AlchemyAssertion<UserToken> validUserTokenIn(@Required @NotNull AuthenticationService.Iface authenticationService) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationService, (String)"authenticationService");
        ArgumentsKtKt.checkThat((Object)authenticationService).usingMessage("authentication service is null").isA(Assertions.notNull());
        return (AlchemyAssertion)new AlchemyAssertion<UserToken>(authenticationService){
            final /* synthetic */ AuthenticationService.Iface $authenticationService;

            public final void check(UserToken token) {
                ArgumentsKtKt.checkThat((Object)token).usingMessage("token is null").isA(Assertions.notNull());
                ArgumentsKtKt.checkThat((Object)token.tokenId).usingMessage("token is missing tokenId").isA(StringAssertions.nonEmptyString());
                AuthenticationToken authToken = new AuthenticationToken().setTokenId(token.tokenId).setOwnerId(token.userId).setOrganizationId(token.organization);
                ArgumentsKtKt.checkThat((Object)authToken).isA(AromaAssertions.validTokenIn(this.$authenticationService));
            }
            {
                this.$authenticationService = iface;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final AlchemyAssertion<AuthenticationToken> validTokenIn(@Required @NotNull AuthenticationService.Iface authenticationService) {
        Intrinsics.checkParameterIsNotNull((Object)authenticationService, (String)"authenticationService");
        ArgumentsKtKt.checkThat((Object)authenticationService).usingMessage("authentication service is null").isA(Assertions.notNull());
        return (AlchemyAssertion)new AlchemyAssertion<AuthenticationToken>(authenticationService){
            final /* synthetic */ AuthenticationService.Iface $authenticationService;

            public final void check(AuthenticationToken token) {
                ArgumentsKtKt.checkThat((Object)token).isA(AromaAssertions.legalToken());
                String tokenId = token.getTokenId();
                ArgumentsKtKt.checkThat((Object)tokenId).usingMessage("tokenId is missing").isA(StringAssertions.nonEmptyString());
                VerifyTokenRequest request = new VerifyTokenRequest().setTokenId(tokenId);
                AuthenticationToken authenticationToken = token;
                Intrinsics.checkExpressionValueIsNotNull((Object)authenticationToken, (String)"token");
                if (authenticationToken.isSetOwnerId()) {
                    request.setOwnerId(token.ownerId);
                }
                try {
                    this.$authenticationService.verifyToken(request);
                }
                catch (InvalidTokenException ex) {
                    throw (Throwable)new FailedAssertionException("Token is not valid");
                }
                catch (Exception ex) {
                    throw (Throwable)new FailedAssertionException("Could not contact Authentication Service", (Throwable)ex);
                }
            }
            {
                this.$authenticationService = iface;
            }
        };
    }

    private AromaAssertions() {
    }

    static {
        AromaAssertions aromaAssertions;
        INSTANCE = aromaAssertions = new AromaAssertions();
    }
}

