/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.client;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.client.exceptions.BananaNetworkException;
import tech.aroma.client.exceptions.BananaOperationFailedException;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.aroma.thrift.endpoint.Endpoint;
import tech.aroma.thrift.endpoint.HttpThriftEndpoint;
import tech.aroma.thrift.endpoint.TcpEndpoint;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.FactoryPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NetworkAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
@FactoryPattern(role=FactoryPattern.Role.FACTORY)
final class ThriftClientProvider
implements Supplier<ApplicationService.Client> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClientProvider.class);
    private final Supplier<Endpoint> endpointSupplier;

    ThriftClientProvider(@Required Supplier<Endpoint> endpointSupplier) {
        Arguments.checkThat(endpointSupplier).is(Assertions.notNull());
        Arguments.checkThat((Object)endpointSupplier.get()).usingMessage("endpointSupplier returned null").is(Assertions.notNull());
        this.endpointSupplier = endpointSupplier;
    }

    @Override
    public ApplicationService.Client get() {
        Endpoint endpoint = this.endpointSupplier.get();
        Arguments.checkThat((Object)endpoint).usingMessage("missing endpoint").is(Assertions.notNull());
        if (endpoint.isSetTcp()) {
            return this.fromTcp(endpoint.getTcp());
        }
        if (endpoint.isSetHttpThrift()) {
            return this.fromHttp(endpoint.getHttpThrift());
        }
        throw new BananaOperationFailedException("Endpoint not supported: " + endpoint);
    }

    private ApplicationService.Client fromTcp(TcpEndpoint tcp) {
        Arguments.checkThat((Object)tcp).usingMessage("missing TCP Endpoint").is(Assertions.notNull());
        String hostname = tcp.hostname;
        int port = tcp.port;
        Arguments.checkThat((Object)hostname).usingMessage("missing hostname").is(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)port).is(NetworkAssertions.validPort());
        long timeout = TimeUnit.SECONDS.toMillis(45L);
        TSocket socket = new TSocket(hostname, port, (int)timeout);
        try {
            socket.open();
        }
        catch (TTransportException ex) {
            LOG.error("Failed to open TCP Port at {}", (Object)tcp, (Object)ex);
            throw new BananaNetworkException("Failed to connect to: " + tcp, ex);
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)socket);
        return new ApplicationService.Client((TProtocol)protocol);
    }

    private ApplicationService.Client fromHttp(HttpThriftEndpoint http) {
        THttpClient client;
        Arguments.checkThat((Object)http).usingMessage("missing HTTP Endpoint").is(Assertions.notNull());
        String url = http.url;
        Arguments.checkThat((Object)url).is(NetworkAssertions.validURL());
        try {
            client = new THttpClient(url);
        }
        catch (TTransportException ex) {
            LOG.error("Failed to create connection to Endpoint: {}", (Object)url);
            throw new BananaNetworkException("Failed to connect to: " + url, ex);
        }
        TJSONProtocol protocol = new TJSONProtocol((TTransport)client);
        return new ApplicationService.Client((TProtocol)protocol);
    }
}

