/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.client.Aroma;
import tech.aroma.client.RequestImpl;
import tech.aroma.client.Urgency;
import tech.aroma.thrift.application.service.ApplicationService;
import tech.aroma.thrift.application.service.SendMessageRequest;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.clients.Clients;

@ThreadSafe
final class AromaClient
implements Aroma {
    private static final Logger LOG = LoggerFactory.getLogger(AromaClient.class);
    private final Supplier<ApplicationService.Iface> applicationServiceProvider;
    private final ExecutorService executor;
    private final ApplicationToken token;

    AromaClient(@Required Supplier<ApplicationService.Iface> applicationServiceProvider, @Required ExecutorService executor, @Required ApplicationToken token) {
        Arguments.checkThat(applicationServiceProvider, (Object[])new Object[]{executor, token}).are(Assertions.notNull());
        Arguments.checkThat((Object)token.tokenId).usingMessage("token is missing").is(StringAssertions.nonEmptyString());
        this.applicationServiceProvider = applicationServiceProvider;
        this.executor = executor;
        this.token = token;
    }

    @Override
    public Aroma.Request begin() {
        return new RequestImpl(this, "", "", Urgency.LOW);
    }

    void sendMessage(@Required RequestImpl request) {
        Instant now = Instant.now();
        SendMessageRequest sendMessageRequest = new SendMessageRequest().setApplicationToken(this.token).setBody(request.getText()).setTitle(request.getTitle()).setUrgency(request.getUrgency().toThrift()).setHostname(this.getHostname()).setIpv4Address(this.getIpv4Address()).setTimeOfMessage(now.toEpochMilli());
        this.executor.submit(() -> this.sendMessageAsync(sendMessageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAsync(SendMessageRequest request) {
        ApplicationService.Iface client = this.applicationServiceProvider.get();
        Arguments.checkThat((Object)client).usingMessage("service provider returned null").is(Assertions.notNull());
        try {
            client.sendMessage(request);
            LOG.debug("Successfully sent message to Banana Application Service");
        }
        catch (TException ex) {
            LOG.error("Failed to send message to Banana Application Service", (Throwable)ex);
        }
        finally {
            Clients.attemptCloseSilently((Object)client);
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOG.warn("Could not determine Hostname", (Throwable)ex);
            return "";
        }
    }

    private String getIpv4Address() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOG.warn("Could not determine IPv4 Address", (Throwable)ex);
            return "";
        }
    }
}

