/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import tech.aroma.client.AromaClient;
import tech.aroma.client.ThriftClientProvider;
import tech.aroma.client.Urgency;
import tech.aroma.client.exceptions.BananaException;
import tech.aroma.thrift.application.service.ApplicationServiceConstants;
import tech.aroma.thrift.authentication.ApplicationToken;
import tech.aroma.thrift.endpoint.Endpoint;
import tech.aroma.thrift.endpoint.TcpEndpoint;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.annotations.designs.patterns.BuilderPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.NetworkAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@ThreadSafe
@BuilderPattern(role=BuilderPattern.Role.PRODUCT)
@FluidAPIDesign
public interface Aroma {
    public Request begin();

    public static Aroma create() {
        return Aroma.create("Aroma");
    }

    public static Aroma create(@NonEmpty String applicationToken) {
        Arguments.checkThat((Object)applicationToken).usingMessage("Application Token cannot be empty").is(StringAssertions.nonEmptyString());
        return Aroma.newBuilder().withAsyncExecutorService(Executors.newSingleThreadExecutor()).withApplicationToken(applicationToken).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BuilderPattern(role=BuilderPattern.Role.BUILDER)
    public static final class Builder {
        private String hostname = ApplicationServiceConstants.PRODUCTION_ENDPOINT.getHostname();
        private int port = ApplicationServiceConstants.PRODUCTION_ENDPOINT.getPort();
        private String applicationToken = "";
        private ExecutorService async;

        Builder() {
        }

        public Builder withApplicationToken(@Required String applicationToken) throws IllegalArgumentException {
            Arguments.checkThat((Object)applicationToken).are(StringAssertions.nonEmptyString());
            this.applicationToken = applicationToken;
            return this;
        }

        public Builder withEndpoint(@NonEmpty String hostname, int port) throws IllegalArgumentException {
            Arguments.checkThat((Object)hostname).usingMessage("hostname cannot be empty").is(StringAssertions.nonEmptyString());
            Arguments.checkThat((Object)port).is(NetworkAssertions.validPort());
            this.hostname = hostname;
            this.port = port;
            return this;
        }

        public Builder withAsyncExecutorService(@Required ExecutorService executor) throws IllegalArgumentException {
            Arguments.checkThat((Object)executor).is(Assertions.notNull());
            this.async = executor;
            return this;
        }

        public Aroma build() throws IllegalStateException {
            Arguments.checkThat((Object)this.hostname).throwing(IllegalStateException.class).usingMessage("missing hostname").is(StringAssertions.nonEmptyString());
            Arguments.checkThat((Object)this.applicationToken).throwing(IllegalStateException.class).usingMessage("missing Application Token").is(StringAssertions.nonEmptyString());
            Arguments.checkThat((Object)this.port).throwing(IllegalStateException.class).is(NetworkAssertions.validPort());
            if (this.async == null) {
                this.async = Executors.newSingleThreadExecutor();
            }
            Endpoint endpoint = this.createEndpoint();
            ApplicationToken token = new ApplicationToken().setTokenId(this.applicationToken);
            ThriftClientProvider clientProvider = new ThriftClientProvider(() -> endpoint);
            AromaClient banana = new AromaClient(() -> clientProvider.get(), this.async, token);
            return banana;
        }

        private Endpoint createEndpoint() {
            TcpEndpoint tcpEndpoint = new TcpEndpoint(this.hostname, this.port);
            Endpoint endpoint = new Endpoint();
            endpoint.setTcp(tcpEndpoint);
            return endpoint;
        }
    }

    public static interface Request {
        public Request text(@Required String var1, Object ... var2);

        public Request titled(@Required String var1);

        public Request withUrgency(@Required Urgency var1) throws IllegalArgumentException;

        public void send() throws IllegalArgumentException, BananaException;
    }
}

