/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.thrift.Role;
import tech.aroma.thrift.User;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002J\u0014\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0011*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Ltech/aroma/data/sql/serializers/UserSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/User;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "user", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "toRole", "Ltech/aroma/thrift/Role;", "toRoles", "", "Ljava/sql/Array;", "aroma-data-operations"})
public final class UserSerializer
implements DatabaseSerializer<User> {
    @Override
    public void save(@NotNull User user, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)user).isA(RequestAssertions.validUser());
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Long birthday = user.isSetBirthdate() ? Long.valueOf(user.birthdate) : null;
        Object[] objectArray = new Object[10];
        objectArray[0] = SQLPlusKt.toUUID(user.userId);
        objectArray[1] = user.firstName;
        objectArray[2] = user.middleName;
        objectArray[3] = user.lastName;
        objectArray[4] = user.name;
        objectArray[5] = user.email;
        Set set = user.roles;
        objectArray[6] = set != null ? SQLPlusKt.toCommaSeparatedList(set) : null;
        Long l = birthday;
        objectArray[7] = l != null ? SQLPlusKt.toTimestamp(l) : null;
        String string = user.profileImageLink;
        objectArray[8] = string != null ? SQLPlusKt.toUUID(string) : null;
        objectArray[9] = user.githubProfile;
        database.update(statement, objectArray);
    }

    @Override
    @NotNull
    public User deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        String userId = row.getString("user_id");
        String firstName = row.getString("first_name");
        String middleName = row.getString("middle_name");
        String lastName = row.getString("last_name");
        String fullName = row.getString("full_name");
        String email = row.getString("email");
        Array array = row.getArray("roles");
        List<Role> roles = array != null ? this.toRoles(array) : null;
        Date birthdate = row.getDate("birthdate");
        String profileImageId = row.getString("profile_image_id");
        String githubProfile = row.getString("github_profile");
        Time time = row.getTime("time_account_created");
        if (time == null) {
            time = null;
        }
        Time timeCreated = time;
        User user = new User().setUserId(userId).setFirstName(firstName).setMiddleName(middleName).setLastName(lastName).setName(fullName).setEmail(email).setGithubProfile(githubProfile).setProfileImageLink(profileImageId);
        if (timeCreated != null) {
            user.timeUserJoined = timeCreated.getTime();
        }
        if (roles != null) {
            user.setRoles(CollectionsKt.toSet((Iterable)roles));
        }
        if (birthdate != null) {
            user.setBirthdate(birthdate.getTime());
        }
        User user2 = user;
        Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"user");
        return user2;
    }

    private final List<Role> toRoles(@NotNull Array $receiver) {
        String string;
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Object object = $receiver.getArray();
        if (!(object instanceof Object[])) {
            object = null;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray == null) {
            return null;
        }
        Object[] array = objectArray;
        Object $receiver$iv = array;
        Object[] objectArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            item$iv$iv = $receiver$iv$iv[i];
            void var8_9 = item$iv$iv;
            collection = destination$iv$iv;
            string = String.valueOf(it);
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            string = this.toRole(it);
            collection.add(string);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    private final Role toRole(@NotNull String $receiver) {
        Role role;
        try {
            role = Role.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return role;
    }
}

