/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.ResultSet;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.thrift.assertions.AromaAssertions;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.authentication.TokenStatus;
import tech.aroma.thrift.authentication.TokenType;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Ltech/aroma/data/sql/serializers/TokenSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/authentication/AuthenticationToken;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "object", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "asStatus", "Ltech/aroma/thrift/authentication/TokenStatus;", "asTokenType", "Ltech/aroma/thrift/authentication/TokenType;", "aroma-data-operations"})
public final class TokenSerializer
implements DatabaseSerializer<AuthenticationToken> {
    @Override
    public void save(@NotNull AuthenticationToken object, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)object).isA(AromaAssertions.INSTANCE.legalToken());
        Arguments.checkThat((Object)object.tokenId).isA(StringAssertions.validUUID());
        AuthenticationToken token = object;
        Object[] objectArray = new Object[8];
        objectArray[0] = SQLPlusKt.toUUID(token.tokenId);
        objectArray[1] = SQLPlusKt.toUUID(token.ownerId);
        objectArray[2] = SQLPlusKt.toUUID(token.organizationId);
        objectArray[3] = token.ownerName;
        objectArray[4] = SQLPlusKt.toTimestamp(token.timeOfCreation);
        objectArray[5] = SQLPlusKt.toTimestamp(token.timeOfExpiration);
        TokenType tokenType = token.tokenType;
        objectArray[6] = tokenType != null ? tokenType.toString() : null;
        TokenStatus tokenStatus = token.status;
        objectArray[7] = tokenStatus != null ? tokenStatus.toString() : null;
        database.update(statement, objectArray);
    }

    @Override
    @NotNull
    public AuthenticationToken deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        AuthenticationToken token = new AuthenticationToken();
        ResultSet results = row;
        String tokenId = results.getString("token_id");
        String ownerId = results.getString("owner_id");
        String orgId = results.getString("organization_id");
        String ownerName = results.getString("owner_name");
        Timestamp timestamp = results.getTimestamp("time_of_creation");
        Long timeOfCreation = timestamp != null ? Long.valueOf(timestamp.getTime()) : null;
        Timestamp timestamp2 = results.getTimestamp("time_of_expiration");
        Long timeOfExpiration = timestamp2 != null ? Long.valueOf(timestamp2.getTime()) : null;
        String string = results.getString("token_type");
        TokenType tokenType = string != null ? this.asTokenType(string) : null;
        String string2 = results.getString("token_status");
        TokenStatus tokenStatus = string2 != null ? this.asStatus(string2) : null;
        token.setTokenId(tokenId).setOwnerId(ownerId).setOrganizationId(orgId).setOwnerName(ownerName).setTokenType(tokenType).setStatus(tokenStatus);
        if (timeOfCreation != null) {
            token.setTimeOfCreation(timeOfCreation.longValue());
        }
        if (timeOfExpiration != null) {
            token.setTimeOfExpiration(timeOfExpiration.longValue());
        }
        return token;
    }

    private final TokenType asTokenType(@NotNull String $receiver) {
        TokenType tokenType;
        try {
            tokenType = TokenType.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return tokenType;
    }

    private final TokenStatus asStatus(@NotNull String $receiver) {
        TokenStatus tokenStatus;
        try {
            tokenStatus = TokenStatus.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return tokenStatus;
    }
}

