/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.thrift.Industry;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.Tier;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Ltech/aroma/data/sql/serializers/OrganizationSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Organization;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "object", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "asIndustry", "Ltech/aroma/thrift/Industry;", "asTier", "Ltech/aroma/thrift/Tier;", "aroma-data-operations"})
public final class OrganizationSerializer
implements DatabaseSerializer<Organization> {
    @Override
    public void save(@NotNull Organization object, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)object, (Object[])new Object[]{statement, database}).are(Assertions.notNull());
        Organization org = object;
        Arguments.checkThat((Object)org).isA(RequestAssertions.validOrganization());
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Object[] objectArray = new Object[11];
        objectArray[0] = SQLPlusKt.toUUID(org.organizationId);
        objectArray[1] = org.organizationName;
        objectArray[2] = SQLPlusKt.toCommaSeparatedList(org.owners);
        objectArray[3] = org.logoLink;
        Industry industry = org.industry;
        objectArray[4] = industry != null ? industry.toString() : null;
        objectArray[5] = org.organizationEmail;
        objectArray[6] = org.githubProfile;
        objectArray[7] = org.stockMarketSymbol;
        Tier tier = org.tier;
        objectArray[8] = tier != null ? tier.toString() : null;
        objectArray[9] = org.organizationDescription;
        objectArray[10] = org.website;
        database.update(statement, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Organization deserialize(@Nullable ResultSet row) {
        Arguments.checkThat((Object)row).isA(Assertions.notNull());
        Organization org = new Organization();
        ResultSet resultSet = row;
        if (resultSet == null) {
            return org;
        }
        ResultSet results = resultSet;
        String orgId = results.getString("organization_id");
        String orgName = results.getString("organization_name");
        String orgDescription = results.getString("description");
        Industry industry = this.asIndustry(results.getString("industry"));
        Tier tier = this.asTier(results.getString("tier"));
        String website = results.getString("website");
        String stock = results.getString("stock_name");
        String iconLink = results.getString("icon_link");
        String github = results.getString("github_profile");
        String email = results.getString("contact_email");
        Array ownersArray = results.getArray("owners");
        if (ownersArray != null && ownersArray.getArray() instanceof Object[]) {
            Object object = ownersArray.getArray();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
            }
            Object[] owners = (Object[])object;
            if (owners instanceof String[]) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object[] objectArray = owners;
                Organization organization = org;
                void var17_18 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    void it;
                    void item$iv$iv;
                    void var21_22 = item$iv$iv = $receiver$iv$iv[i];
                    collection = destination$iv$iv;
                    String string = String.valueOf(it);
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                organization.setOwners((List)collection);
            }
        }
        Organization organization = org.setOrganizationId(orgId).setOrganizationName(orgName).setOrganizationDescription(orgDescription).setIndustry(industry).setTier(tier).setWebsite(website).setStockMarketSymbol(stock).setLogoLink(iconLink).setGithubProfile(github).setOrganizationEmail(email);
        Intrinsics.checkExpressionValueIsNotNull((Object)organization, (String)"org\n                .set\u2026tOrganizationEmail(email)");
        return organization;
    }

    private final Tier asTier(@NotNull String $receiver) {
        Tier tier;
        try {
            tier = Tier.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return tier;
    }

    private final Industry asIndustry(@NotNull String $receiver) {
        Industry industry;
        try {
            industry = Industry.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return industry;
    }
}

