/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.Timestamps;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Urgency;
import tech.aroma.thrift.message.service.MessageServiceConstants;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Ltech/aroma/data/sql/serializers/MessageSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Message;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "message", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "asUrgency", "Ltech/aroma/thrift/Urgency;", "Companion", "aroma-data-operations"})
public final class MessageSerializer
implements DatabaseSerializer<Message> {
    private static final Logger LOG;
    private static final LengthOfTime DEFAULT_TTL;
    public static final Companion Companion;

    @Override
    public void save(@NotNull Message message, @NotNull String statement, @NotNull JdbcOperations database) throws SQLException {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)message).isA(RequestAssertions.validMessage());
        Arguments.checkThat((Object)database).isA(Assertions.notNull());
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Timestamp timeCreated = message.timeOfCreation > (long)0 ? SQLPlusKt.toTimestamp(message.timeOfCreation) : Timestamps.INSTANCE.now();
        Timestamp timeReceived = message.timeMessageReceived > (long)0 ? SQLPlusKt.toTimestamp(message.timeMessageReceived) : Timestamps.INSTANCE.now();
        Object[] objectArray = new Object[11];
        objectArray[0] = SQLPlusKt.toUUID(message.messageId);
        objectArray[1] = SQLPlusKt.toUUID(message.applicationId);
        objectArray[2] = message.applicationName;
        objectArray[3] = message.title;
        objectArray[4] = message.body;
        Object object = message.urgency;
        if (object == null || (object = object.toString()) == null) {
            object = Urgency.MEDIUM.toString();
        }
        objectArray[5] = object;
        objectArray[6] = timeCreated;
        objectArray[7] = timeReceived;
        objectArray[8] = message.hostname;
        objectArray[9] = message.macAddress;
        objectArray[10] = message.deviceName;
        database.update(statement, objectArray);
    }

    @Override
    @NotNull
    public Message deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        Message message = new Message();
        message.applicationId = row.getString("app_id");
        message.messageId = row.getString("message_id");
        message.applicationName = row.getString("app_name");
        message.title = row.getString("title");
        message.body = row.getString("body");
        message.hostname = row.getString("hostname");
        if (SQLPlusKt.hasColumn(row, "ip_address")) {
            message.macAddress = row.getString("ip_address");
        }
        message.deviceName = row.getString("device_name");
        message.urgency = this.asUrgency(row.getString("priority"));
        Timestamp timestamp = row.getTimestamp("time_created");
        message.timeOfCreation = timestamp != null ? timestamp.getTime() : 0L;
        Timestamp timestamp2 = row.getTimestamp("time_received");
        message.timeMessageReceived = timestamp2 != null ? timestamp2.getTime() : 0L;
        return message;
    }

    private final Urgency asUrgency(@NotNull String $receiver) {
        Urgency urgency;
        try {
            urgency = Urgency.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            Companion.getLOG().error("Could not parse Urgency " + $receiver, (Throwable)ex);
            return null;
        }
        return urgency;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(MessageSerializer.class);
        DEFAULT_TTL = MessageServiceConstants.DEFAULT_MESSAGE_LIFETIME;
    }

    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    public static final LengthOfTime getDEFAULT_TTL() {
        return Companion.getDEFAULT_TTL();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\n0\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ltech/aroma/data/sql/serializers/MessageSerializer$Companion;", "", "()V", "DEFAULT_TTL", "Ltech/aroma/thrift/LengthOfTime;", "kotlin.jvm.PlatformType", "DEFAULT_TTL$annotations", "getDEFAULT_TTL", "()Ltech/aroma/thrift/LengthOfTime;", "LOG", "Lorg/slf4j/Logger;", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        public static /* synthetic */ void DEFAULT_TTL$annotations() {
        }

        public final LengthOfTime getDEFAULT_TTL() {
            return DEFAULT_TTL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

