/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.ImageType;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Ltech/aroma/data/sql/serializers/ImageSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Image;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "image", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "toImageType", "Ltech/aroma/thrift/ImageType;", "aroma-data-operations"})
public final class ImageSerializer
implements DatabaseSerializer<Image> {
    @Override
    public void save(@NotNull Image image, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)image).isA(RequestAssertions.validImage());
    }

    @Override
    @NotNull
    public Image deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        Image image = new Image();
        String mediaType = row.getString("media_type");
        int width = row.getInt("width");
        int height = row.getInt("height");
        byte[] data = row.getBytes("data");
        if (width > 0 && height > 0) {
            image.dimension = new Dimension(width, height);
        }
        image.imageType = this.toImageType(mediaType);
        image.setData(data);
        return image;
    }

    private final ImageType toImageType(@NotNull String $receiver) {
        ImageType imageType;
        try {
            imageType = ImageType.valueOf((String)$receiver);
        }
        catch (Exception ex) {
            return null;
        }
        return imageType;
    }
}

