/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.thrift.events.Event;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Ltech/aroma/data/sql/serializers/EventSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/events/Event;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "event", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "aroma-data-operations"})
public final class EventSerializer
implements DatabaseSerializer<Event> {
    @Override
    public void save(@NotNull Event event, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)event.eventId).isA(StringAssertions.validUUID());
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
    }

    @Override
    @NotNull
    public Event deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        Event event = new Event();
        String serializedEvent = row.getString("serialized_event");
        if (serializedEvent != null) {
            TBase tBase = ThriftObjects.fromJson((TBase)((TBase)event), (String)serializedEvent);
            Intrinsics.checkExpressionValueIsNotNull((Object)tBase, (String)"ThriftObjects.fromJson(event, serializedEvent)");
            event = (Event)tBase;
        }
        return event;
    }
}

