/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.thrift.channels.MobileDevice;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Ltech/aroma/data/sql/serializers/DevicesSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "", "Ltech/aroma/thrift/channels/MobileDevice;", "()V", "deserialize", "row", "Ljava/sql/ResultSet;", "deviceFromJson", "json", "", "save", "", "devices", "statement", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "Companion", "aroma-data-operations"})
public final class DevicesSerializer
implements DatabaseSerializer<Set<MobileDevice>> {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void save(@NotNull Set<MobileDevice> devices, @NotNull String statement, @NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull(devices, (String)"devices");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        Iterable $receiver$iv = devices;
        for (Object element$iv : $receiver$iv) {
            MobileDevice it = (MobileDevice)element$iv;
            Arguments.checkThat((Object)it).isA(RequestAssertions.validMobileDevice());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<MobileDevice> deserialize(@NotNull ResultSet row) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        Array array = row.getArray("serialized_devices");
        if (array == null) {
            return new LinkedHashSet();
        }
        Array devicesArray = array;
        Object object = devicesArray.getArray();
        if (!(object instanceof String[])) {
            object = null;
        }
        String[] stringArray = (String[])object;
        if (stringArray == null) {
            return new LinkedHashSet();
        }
        String[] devices = stringArray;
        Object[] objectArray = devices;
        DevicesSerializer devicesSerializer = this;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void p1;
            void item$iv$iv = $receiver$iv$iv[i];
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            MobileDevice mobileDevice = devicesSerializer.deviceFromJson((String)p1);
            collection.add(mobileDevice);
        }
        return CollectionsKt.toMutableSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    private final MobileDevice deviceFromJson(String json) {
        MobileDevice mobileDevice;
        try {
            mobileDevice = (MobileDevice)ThriftObjects.fromJson((TBase)((TBase)new MobileDevice()), (String)json);
        }
        catch (Exception ex) {
            Companion.getLOG().error("Failed to parse Mobile Device from JSON | " + json, (Throwable)ex);
            return null;
        }
        return mobileDevice;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @NotNull
    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/serializers/DevicesSerializer$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

