/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql.serializers;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.ProgrammingLanguage;
import tech.aroma.thrift.Tier;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u0004\u0018\u00010\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/aroma/data/sql/serializers/ApplicationSerializer;", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Application;", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "deserialize", "row", "Ljava/sql/ResultSet;", "save", "", "app", "statement", "", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "toProgrammingLanguage", "Ltech/aroma/thrift/ProgrammingLanguage;", "toTier", "Ltech/aroma/thrift/Tier;", "aroma-data-operations"})
public final class ApplicationSerializer
implements DatabaseSerializer<Application> {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull Application app, @NotNull String statement, @NotNull JdbcOperations database) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Arguments.checkThat((Object)app).isA(RequestAssertions.validApplication());
        Arguments.checkThat((Object)statement).isA(StringAssertions.nonEmptyString());
        UUID appId = SQLPlusKt.toUUID(app.applicationId);
        Iterable iterable = app.owners;
        void var7_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            UUID uUID = UUID.fromString((String)p1);
            collection.add(uUID);
        }
        String owners = SQLPlusKt.toCommaSeparatedList(CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        database.update(statement, new Object[]{appId, app.name, app.applicationDescription, SQLPlusKt.toUUID(app.organizationId), app.programmingLanguage.toString(), app.tier.toString(), SQLPlusKt.toTimestamp(app.timeOfTokenExpiration), SQLPlusKt.toUUID(app.applicationIconMediaId), owners});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Application deserialize(@NotNull ResultSet row) {
        Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
        Application app = new Application();
        String appId = row.getString("app_id");
        String orgId = row.getString("organization_id");
        String appName = row.getString("app_name");
        String appDescription = row.getString("app_description");
        ProgrammingLanguage programmingLanguage = this.toProgrammingLanguage(row.getString("programming_language"));
        Timestamp timeProvisioned = row.getTimestamp("time_provisioned");
        Timestamp timeOfTokenExpiration = row.getTimestamp("time_of_token_expiration");
        Tier tier = this.toTier(row.getString("tier"));
        String appIconId = row.getString("app_icon_media_id");
        Array array = row.getArray("owners");
        Object owners = array != null ? array.getArray() : null;
        app.setApplicationId(appId).setOrganizationId(orgId).setName(appName).setApplicationDescription(appDescription).setProgrammingLanguage(programmingLanguage).setTier(tier).setApplicationIconMediaId(appIconId);
        if (timeProvisioned != null) {
            app.setTimeOfProvisioning(timeProvisioned.getTime());
        }
        if (timeOfTokenExpiration != null) {
            app.setTimeOfTokenExpiration(timeOfTokenExpiration.getTime());
        }
        if (owners != null && owners instanceof Object[]) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = ArraysKt.filterNotNull((Object[])((Object[])owners));
            Application application = app;
            void var14_15 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                String string = String.valueOf(it);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            application.owners = CollectionsKt.toSet((Iterable)collection);
        }
        return app;
    }

    private final Tier toTier(@Nullable String $receiver) {
        Tier tier;
        if ($receiver == null) {
            return null;
        }
        try {
            tier = Tier.valueOf((String)$receiver);
        }
        catch (RuntimeException ex) {
            this.LOG.error("Failed to extract Tier from [" + $receiver + "]");
            return null;
        }
        return tier;
    }

    private final ProgrammingLanguage toProgrammingLanguage(@Nullable String $receiver) {
        ProgrammingLanguage programmingLanguage;
        if ($receiver == null) {
            return null;
        }
        try {
            programmingLanguage = ProgrammingLanguage.valueOf((String)$receiver);
        }
        catch (RuntimeException ex) {
            this.LOG.error("Failed to ascertain Programming Language from [" + $receiver + "]");
            return null;
        }
        return programmingLanguage;
    }
}

