/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.UserRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.PeopleAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Ltech/aroma/data/sql/SQLUserRepository;", "Ltech/aroma/data/UserRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/User;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "containsUser", "", "userId", "", "deleteUser", "", "findByGithubProfile", "githubProfile", "getRecentlyCreatedUsers", "", "getUser", "getUserByEmail", "emailAddress", "logAndFailWithNoSuchUser", "", "message", "saveUser", "user", "Companion", "aroma-data-operations"})
public final class SQLUserRepository
implements UserRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<User> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveUser(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUser());
        String sql = SQLStatements.Inserts.USER;
        try {
            this.serializer.save(user, sql, this.database);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save user in database: [" + user + "]", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public User getUser(@NotNull String userId) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.SELECT_USER;
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ializer, userId.toUUID())");
            user = (User)object;
        }
        catch (EmptyResultDataAccessException ex) {
            Void void_ = this.logAndFailWithNoSuchUser(userId);
            throw null;
        }
        catch (Exception ex) {
            String message = "Failed to retrieve User with ID [" + userId + "] from database";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return user;
    }

    @Override
    public void deleteUser(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Deletes.USER;
        try {
            int updated = this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId)});
            SQLUserRepository.Companion.getLOG().info("Successfully deleted " + userId + ". " + updated + " rows affedted");
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete user " + userId, ex);
            throw null;
        }
    }

    @Override
    public boolean containsUser(@NotNull String userId) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.CHECK_USER;
        try {
            Object object = this.database.queryForObject(sql, Boolean.TYPE, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ss.java, userId.toUUID())");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to check if user exists: [" + userId + "]", ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public User getUserByEmail(@NotNull String emailAddress) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)emailAddress, (String)"emailAddress");
        Arguments.checkThat((Object)emailAddress).throwing(InvalidArgumentException.class).isA(PeopleAssertions.validEmailAddress());
        String sql = SQLStatements.Queries.SELECT_USER_BY_EMAIL;
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{emailAddress});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026serializer, emailAddress)");
            user = (User)object;
        }
        catch (EmptyResultDataAccessException ex) {
            String message = "Could not find a user with email address: [" + emailAddress + "]";
            Void void_ = this.logAndFailWithNoSuchUser(message);
            throw null;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to get a user by " + emailAddress, ex);
            throw null;
        }
        return user;
    }

    @Override
    @NotNull
    public User findByGithubProfile(@NotNull String githubProfile) {
        User user;
        Intrinsics.checkParameterIsNotNull((Object)githubProfile, (String)"githubProfile");
        Arguments.checkThat((Object)githubProfile).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString());
        String sql = SQLStatements.Queries.SELECT_USER_BY_GITHUB;
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{githubProfile});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026erializer, githubProfile)");
            user = (User)object;
        }
        catch (EmptyResultDataAccessException ex) {
            String message = "Could not find a user with Github profile [" + githubProfile + "]";
            Void void_ = this.logAndFailWithNoSuchUser(message);
            throw null;
        }
        catch (Exception ex) {
            String message = "Failed to query for a user with Github profile [" + githubProfile + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return user;
    }

    @Override
    @NotNull
    public List<User> getRecentlyCreatedUsers() {
        List list;
        String sql = SQLStatements.Queries.SELECT_RECENT_USERS;
        try {
            List list2 = this.database.query(sql, (RowMapper)this.serializer);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(sql, serializer)");
            list = list2;
        }
        catch (Exception ex) {
            String message = "Failed to return a list of recent Users";
            SQLUserRepository.Companion.getLOG().error(message, (Throwable)ex);
            return new ArrayList();
        }
        return list;
    }

    private final Void logAndFailWithNoSuchUser(String message) {
        String string = message;
        if (string == null) {
            string = "User does not exist";
        }
        String message2 = string;
        SQLUserRepository.Companion.getLOG().warn(message2);
        throw (Throwable)new DoesNotExistException(message2);
    }

    static /* bridge */ /* synthetic */ Void logAndFailWithNoSuchUser$default(SQLUserRepository sQLUserRepository, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return sQLUserRepository.logAndFailWithNoSuchUser(string);
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<User> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLUserRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<User> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/SQLUserRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

