/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Ltech/aroma/data/sql/SQLUserPreferencesRepository;", "Ltech/aroma/data/UserPreferencesRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "", "Ltech/aroma/thrift/channels/MobileDevice;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkMobileDevice", "", "device", "deleteAllMobileDevices", "userId", "", "deleteMobileDevice", "mobileDevice", "deviceToJson", "getMobileDevices", "saveMobileDevice", "saveMobileDevices", "devices", "Companion", "aroma-data-operations"})
public final class SQLUserPreferencesRepository
implements UserPreferencesRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Set<MobileDevice>> serializer;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveMobileDevice(@NotNull String userId, @NotNull MobileDevice device) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        RepositoriesPlusKt.checkUserId(userId);
        this.checkMobileDevice(device);
        String sql = SQLStatements.Inserts.ADD_USER_DEVICE;
        try {
            string = ThriftObjects.toJson((TBase)((TBase)device));
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to serialized Mobile Device: [" + device + "]", ex);
            throw null;
        }
        String serialized = string;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId), serialized});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save a new mobile device for [" + userId + "]", ex);
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveMobileDevices(@NotNull String userId, @NotNull Set<MobileDevice> devices) {
        void $receiver$iv$iv;
        void $receiver$iv;
        MobileDevice p1;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull(devices, (String)"devices");
        RepositoriesPlusKt.checkUserId(userId);
        Iterable iterable = devices;
        SQLUserPreferencesRepository sQLUserPreferencesRepository = this;
        for (Object element$iv : $receiver$iv2) {
            p1 = (MobileDevice)element$iv;
            sQLUserPreferencesRepository.checkMobileDevice(p1);
        }
        String sql = SQLStatements.Inserts.USER_DEVICES;
        Iterable iterable2 = devices;
        SQLUserPreferencesRepository sQLUserPreferencesRepository2 = this;
        p1 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p12;
            MobileDevice mobileDevice = (MobileDevice)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = sQLUserPreferencesRepository2.deviceToJson((MobileDevice)p12);
            collection.add(string);
        }
        List serialized = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        try {
            this.database.update(sql, new PreparedStatementSetter(userId, serialized){
                final /* synthetic */ String $userId;
                final /* synthetic */ List $serialized;

                public final void setValues(PreparedStatement preparedStatement) {
                    Collection $receiver$iv;
                    preparedStatement.setObject(1, SQLPlusKt.toUUID(this.$userId));
                    Collection collection = $receiver$iv = (Collection)this.$serialized;
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] serializedStringArray = stringArray;
                    Array serializedDevices = preparedStatement.getConnection().createArrayOf("TEXT", serializedStringArray);
                    preparedStatement.setArray(2, serializedDevices);
                }
                {
                    this.$userId = string;
                    this.$serialized = list;
                }
            });
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save " + devices.size() + " devices for [" + userId + "]", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public Set<MobileDevice> getMobileDevices(@NotNull String userId) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.SELECT_USER_DEVICES;
        try {
            Set set2 = (Set)this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(userId)});
            if (set2 == null) {
                set2 = new LinkedHashSet();
            }
            set = set2;
        }
        catch (EmptyResultDataAccessException ex) {
            set = new LinkedHashSet();
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to get mobile devices for [" + userId + "]", ex);
            throw null;
        }
        return set;
    }

    @Override
    public void deleteMobileDevice(@NotNull String userId, @NotNull MobileDevice mobileDevice) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)mobileDevice, (String)"mobileDevice");
        RepositoriesPlusKt.checkUserId(userId);
        this.checkMobileDevice(mobileDevice);
        String sql = SQLStatements.Deletes.USER_DEVICE;
        String serialized = ThriftObjects.toJson((TBase)((TBase)mobileDevice));
        try {
            this.database.update(sql, new Object[]{serialized, SQLPlusKt.toUUID(userId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to remove device for user [" + userId + "] | [" + mobileDevice + "]", ex);
            throw null;
        }
    }

    @Override
    public void deleteAllMobileDevices(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Deletes.ALL_USER_DEVICES;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete all mobile devices for [" + userId + "]", ex);
            throw null;
        }
    }

    private final String deviceToJson(MobileDevice device) {
        String string;
        try {
            string = ThriftObjects.toJson((TBase)((TBase)device));
        }
        catch (Exception ex) {
            Companion.getLOG().warn("Failed to serialized mobile device [" + device + "]", (Throwable)ex);
            return null;
        }
        return string;
    }

    private final void checkMobileDevice(MobileDevice device) {
        Arguments.checkThat((Object)device).throwing(InvalidArgumentException.class).isA(RequestAssertions.validMobileDevice());
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Set<MobileDevice>> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLUserPreferencesRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Set<MobileDevice>> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @NotNull
    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/SQLUserPreferencesRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

