/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.TokenRepository;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.assertions.AromaAssertions;
import tech.aroma.thrift.authentication.AuthenticationToken;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.InvalidTokenException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ltech/aroma/data/sql/SQLTokenRepository;", "Ltech/aroma/data/TokenRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/authentication/AuthenticationToken;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkTokenId", "", "tokenId", "containsToken", "", "deleteToken", "", "getToken", "getTokensBelongingTo", "", "ownerId", "saveToken", "token", "Companion", "aroma-data-operations"})
public final class SQLTokenRepository
implements TokenRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<AuthenticationToken> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public boolean containsToken(@NotNull String tokenId) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
        String tokenId2 = this.checkTokenId(tokenId);
        String query = SQLStatements.Queries.CHECK_TOKEN;
        try {
            Object object = this.database.queryForObject(query, Boolean.TYPE, new Object[]{SQLPlusKt.toUUID(tokenId2)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026s.java, tokenId.toUUID())");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not check if token exists: [" + tokenId2 + "]", ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public AuthenticationToken getToken(@NotNull String tokenId) {
        AuthenticationToken authenticationToken;
        Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
        String tokenId2 = this.checkTokenId(tokenId);
        String query = SQLStatements.Queries.SELECT_TOKEN;
        try {
            Object object = this.database.queryForObject(query, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(tokenId2)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026alizer, tokenId.toUUID())");
            authenticationToken = (AuthenticationToken)object;
        }
        catch (EmptyResultDataAccessException ex) {
            String message = "Token does not exist: [" + tokenId2 + "]";
            SQLTokenRepository.Companion.getLOG().warn(message, (Throwable)ex);
            throw (Throwable)new InvalidTokenException(message);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not get token with ID [" + tokenId2 + "]", ex);
            throw null;
        }
        return authenticationToken;
    }

    @Override
    public void saveToken(@Nullable AuthenticationToken token) {
        Arguments.checkThat((Object)token).throwing(InvalidArgumentException.class).usingMessage("mising token").isA(Assertions.nonNullReference());
        AuthenticationToken authenticationToken = token;
        if (authenticationToken == null) {
            Intrinsics.throwNpe();
        }
        Arguments.checkThat((Object)authenticationToken).throwing(InvalidArgumentException.class).isA(AromaAssertions.INSTANCE.legalToken());
        Arguments.checkThat((Object)token.tokenId).throwing(InvalidArgumentException.class).usingMessage("Token is invalid").isA(StringAssertions.validUUID());
        String statement = SQLStatements.Inserts.TOKEN;
        try {
            this.serializer.save(token, statement, this.database);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save Token [" + token + "]", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public List<AuthenticationToken> getTokensBelongingTo(@NotNull String ownerId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ownerId, (String)"ownerId");
        Arguments.checkThat((Object)ownerId).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString()).isA(StringAssertions.validUUID());
        String query = SQLStatements.Queries.SELECT_TOKENS_FOR_OWNER;
        try {
            List list2 = this.database.query(query, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(ownerId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(query, se\u2026alizer, ownerId.toUUID())");
            list = list2;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not get tokens belonging to [" + ownerId + "]", ex);
            throw null;
        }
        return list;
    }

    @Override
    public void deleteToken(@NotNull String tokenId) {
        Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
        String tokenId2 = this.checkTokenId(tokenId);
        String statement = SQLStatements.Deletes.TOKEN;
        try {
            this.database.update(statement, new Object[]{SQLPlusKt.toUUID(tokenId2)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not remove token [" + tokenId2 + "]", ex);
            throw null;
        }
    }

    private final String checkTokenId(String tokenId) {
        Arguments.checkThat((Object)tokenId).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString()).isA(StringAssertions.validUUID());
        return tokenId;
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<AuthenticationToken> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLTokenRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<AuthenticationToken> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    private static final Logger getLOG() {
        return SQLTokenRepository.Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ltech/aroma/data/sql/SQLTokenRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void LOG$annotations() {
        }

        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

