/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.ReactionRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.reactions.Reaction;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ltech/aroma/data/sql/SQLReactionRepository;", "Ltech/aroma/data/ReactionRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "", "Ltech/aroma/thrift/reactions/Reaction;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkReactions", "", "reactions", "", "clearReactionsForOwner", "ownerId", "", "getReactionsForApplication", "appId", "getReactionsForOwner", "getReactionsForUser", "userId", "saveReactionsForApplication", "saveReactionsForOwner", "saveReactionsForUser", "Companion", "aroma-data-operations"})
public final class SQLReactionRepository
implements ReactionRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<List<Reaction>> serializer;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void saveReactionsForUser(@NotNull String userId, @NotNull List<? extends Reaction> reactions) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull(reactions, (String)"reactions");
        RepositoriesPlusKt.checkUserId(userId);
        this.saveReactionsForOwner(userId, reactions);
    }

    @Override
    @NotNull
    public List<Reaction> getReactionsForUser(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        return this.getReactionsForOwner(userId);
    }

    public void saveReactionsForApplication(@NotNull String appId, @NotNull List<? extends Reaction> reactions) {
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull(reactions, (String)"reactions");
        RepositoriesPlusKt.checkAppId(appId);
        this.saveReactionsForOwner(appId, reactions);
    }

    @Override
    @NotNull
    public List<Reaction> getReactionsForApplication(@NotNull String appId) {
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        RepositoriesPlusKt.checkAppId(appId);
        return this.getReactionsForOwner(appId);
    }

    private final List<Reaction> getReactionsForOwner(String ownerId) {
        List list;
        String sql = SQLStatements.Queries.SELECT_REACTION;
        try {
            List list2 = (List)this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(ownerId)});
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list = list2;
        }
        catch (EmptyResultDataAccessException ex) {
            return new ArrayList();
        }
        catch (Exception ex) {
            String message = "Failed to query reactions for reactions belonging to [" + ownerId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveReactionsForOwner(String ownerId, List<? extends Reaction> reactions) {
        Iterable $receiver$iv;
        this.checkReactions(reactions);
        this.clearReactionsForOwner(ownerId);
        String sql = SQLStatements.Inserts.REACTION;
        try {
            Iterable $receiver$iv$iv;
            Iterable iterable = $receiver$iv = (Iterable)reactions;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                Reaction reaction = (Reaction)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = ThriftObjects.toJson((TBase)((TBase)p1));
                collection.add(string);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                CharSequence charSequence = it;
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to serialized Reactions", ex);
            throw null;
        }
        Iterable serialized = $receiver$iv;
        try {
            this.database.update(sql, new PreparedStatementSetter((List)serialized, ownerId){
                final /* synthetic */ List $serialized;
                final /* synthetic */ String $ownerId;

                /*
                 * WARNING - void declaration
                 */
                public final void setValues(PreparedStatement statement) {
                    void $receiver$iv;
                    Collection collection = this.$serialized;
                    String string = "text";
                    Connection connection = statement.getConnection();
                    void v0 = $receiver$iv;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    void thisCollection$iv = v0;
                    Object[] objectArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                    if (objectArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Object[] objectArray2 = objectArray;
                    Array array = connection.createArrayOf(string, objectArray2);
                    statement.setObject(1, SQLPlusKt.toUUID(this.$ownerId));
                    statement.setArray(2, array);
                }
                {
                    this.$serialized = list;
                    this.$ownerId = string;
                }
            });
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save reactions", ex);
            throw null;
        }
    }

    private final void clearReactionsForOwner(String ownerId) {
        String sql = SQLStatements.Deletes.REACTIONS;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(ownerId)});
        }
        catch (Exception ex) {
            Companion.getLOG().warn("Failed to clear Reactions for [" + ownerId + "]");
        }
    }

    private final void checkReactions(List<? extends Reaction> reactions) {
        Iterable $receiver$iv = reactions;
        for (Object element$iv : $receiver$iv) {
            Reaction it = (Reaction)element$iv;
            Arguments.checkThat((Object)it).throwing(InvalidArgumentException.class).isA(RequestAssertions.validReaction());
        }
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<List<Reaction>> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLReactionRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<List<Reaction>> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @NotNull
    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/SQLReactionRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

