/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import sir.wellington.alchemy.collections.lists.Lists;
import tech.aroma.data.OrganizationRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u0013\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0016\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u001b\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u001c\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010!\u001a\u00020\u000eH\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/aroma/data/sql/SQLOrganizationRepository;", "Ltech/aroma/data/OrganizationRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Organization;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkOrgID", "", "orgId", "", "containsOrganization", "", "organizationId", "deleteAllMembers", "deleteMember", "userId", "deleteOrganization", "getOrganization", "getOrganizationMembers", "", "Ltech/aroma/thrift/User;", "getOrganizationOwners", "isMemberInOrganization", "saveMemberInOrganization", "user", "saveOrganization", "organization", "searchByName", "searchTerm", "aroma-data-operations"})
public final class SQLOrganizationRepository
implements OrganizationRepository {
    private final Logger LOG;
    private final JdbcOperations database;
    private final DatabaseSerializer<Organization> serializer;

    @Override
    public void saveOrganization(@NotNull Organization organization) {
        Intrinsics.checkParameterIsNotNull((Object)organization, (String)"organization");
        Arguments.checkThat((Object)organization).throwing(InvalidArgumentException.class).isA(Assertions.notNull()).isA(RequestAssertions.validOrganization());
        Organization organization2 = organization;
        String statement = SQLStatements.Inserts.ORGANIZATION;
        try {
            this.serializer.save(organization2, statement, this.database);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save organization to database: [" + organization2 + "]", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public Organization getOrganization(@Nullable String organizationId) {
        this.checkOrgID(organizationId);
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID uUID = SQLPlusKt.toUUID(string);
        if (uUID == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = uUID;
        String query = SQLStatements.Queries.SELECT_ORGANIZATION;
        try {
            Object object = this.database.queryForObject(query, (RowMapper)this.serializer, new Object[]{orgId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(query, serializer, orgId)");
            return (Organization)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not get org with ID [" + orgId + "]", ex);
            throw null;
        }
    }

    @Override
    public void deleteOrganization(@Nullable String organizationId) {
        this.checkOrgID(organizationId);
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String orgId = string;
        Organization org = this.getOrganization(orgId);
        List<User> members = this.getOrganizationMembers(orgId);
        String deleteOrg = SQLStatements.Deletes.ORGANIZATION;
        String deleteOrgMembers = SQLStatements.Deletes.ORGANIZATION_ALL_MEMBERS;
        try {
            this.database.update(deleteOrgMembers, new Object[]{SQLPlusKt.toUUID(orgId)});
            this.database.update(deleteOrg, new Object[]{SQLPlusKt.toUUID(orgId)});
        }
        catch (Exception ex) {
            this.saveOrganization(org);
            Iterable $receiver$iv = members;
            for (Object element$iv : $receiver$iv) {
                User it = (User)element$iv;
                this.saveMemberInOrganization(orgId, it);
            }
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete organization [" + org + "]. Rolling back operation.", ex);
            throw null;
        }
    }

    @Override
    public boolean containsOrganization(@Nullable String organizationId) {
        this.checkOrgID(organizationId);
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        String query = SQLStatements.Queries.CHECK_ORGANIZATION;
        try {
            Object object = this.database.queryForObject(query, Boolean.TYPE, new Object[]{orgId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026olean::class.java, orgId)");
            return (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to check if " + orgId + " exists ", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public List<Organization> searchByName(@NotNull String searchTerm) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Arguments.checkThat((Object)searchTerm).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString());
        String sqlReadySearchTerm = "%" + searchTerm + "%";
        String query = SQLStatements.Queries.SEARCH_ORGANIZATION_BY_NAME;
        List result = new ArrayList();
        try {
            List list = this.database.query(query, (RowMapper)this.serializer, new Object[]{sqlReadySearchTerm});
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.query(query, se\u2026izer, sqlReadySearchTerm)");
            result = list;
        }
        catch (Exception ex) {
            this.LOG.warn("Could not find Organizations with name [{}].", (Object)sqlReadySearchTerm, (Object)ex);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<User> getOrganizationOwners(@Nullable String organizationId) {
        List list;
        this.checkOrgID(organizationId);
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.getOrganization((String)organizationId).owners;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                User user = new User().setUserId((String)it);
                collection.add(user);
            }
            list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        catch (Exception ex) {
            return new ArrayList();
        }
        return list;
    }

    @Override
    public void saveMemberInOrganization(@Nullable String organizationId, @Nullable User user) {
        this.checkOrgID(organizationId);
        User user2 = user;
        Arguments.checkThat((Object)(user2 != null ? user2.userId : null)).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUserId());
        String statement = SQLStatements.Inserts.ORGANIZATION_MEMBER;
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        User user3 = user;
        if (user3 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = user3.userId;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        UUID userId = SQLPlusKt.toUUID(string2);
        try {
            this.database.update(statement, new Object[]{orgId, userId});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save user " + userId + " in Org [" + orgId + "]", ex);
            throw null;
        }
    }

    @Override
    public boolean isMemberInOrganization(@Nullable String organizationId, @Nullable String userId) {
        this.checkOrgID(organizationId);
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUserId());
        String query = SQLStatements.Queries.CHECK_ORGANIZATION_HAS_MEMBER;
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        String string2 = userId;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        UUID userId2 = SQLPlusKt.toUUID(string2);
        try {
            Object object = this.database.queryForObject(query, Boolean.TYPE, new Object[]{orgId, userId2});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026lass.java, orgId, userId)");
            return (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to check if [" + userId2 + "] is a member of [" + orgId + "]", ex);
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<User> getOrganizationMembers(@Nullable String organizationId) {
        this.checkOrgID(organizationId);
        String query = SQLStatements.Queries.SELECT_ORGANIZATION_MEMBERS;
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        try {
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = this.database.queryForList(query, String.class, new Object[]{orgId});
            void var5_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                User user = new User().setUserId((String)it);
                collection.add(user);
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        catch (Exception ex) {
            this.LOG.warn("Failed to retrieve organizations member: [{}]", (Object)orgId, (Object)ex);
            List list = Lists.emptyList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"Lists.emptyList()");
            return list;
        }
    }

    @Override
    public void deleteMember(@Nullable String organizationId, @Nullable String userId) {
        this.checkOrgID(organizationId);
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUserId());
        String statement = SQLStatements.Deletes.ORGANIZATION_MEMBER;
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        String string2 = userId;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        UUID userId2 = SQLPlusKt.toUUID(string2);
        try {
            this.database.update(statement, new Object[]{orgId, userId2});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to remove member " + userId2 + " from " + organizationId, ex);
            throw null;
        }
    }

    @Override
    public void deleteAllMembers(@Nullable String organizationId) {
        this.checkOrgID(organizationId);
        String statement = SQLStatements.Deletes.ORGANIZATION_ALL_MEMBERS;
        String string = organizationId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        UUID orgId = SQLPlusKt.toUUID(string);
        try {
            this.database.update(statement, new Object[]{orgId});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to remove all members for Org: [" + orgId + "]", ex);
            throw null;
        }
    }

    private final void checkOrgID(String orgId) {
        Arguments.checkThat((Object)orgId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validOrgId());
    }

    @Inject
    public SQLOrganizationRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Organization> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.database = database;
        this.serializer = serializer;
    }
}

