/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.MessageRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.arguments.Optional;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0017J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0017J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0017J\u001c\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltech/aroma/data/sql/SQLMessageRepository;", "Ltech/aroma/data/MessageRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Message;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "_saveMessage", "", "message", "containsMessage", "", "applicationId", "", "messageId", "deleteMessage", "getByApplication", "", "getByHostname", "hostname", "getByTitle", "title", "getCountByApplication", "", "getMessage", "saveMessage", "lifetime", "Ltech/aroma/thrift/LengthOfTime;", "Companion", "aroma-data-operations"})
@Internal
public final class SQLMessageRepository
implements MessageRepository {
    private final JdbcOperations database;
    private final DatabaseSerializer<Message> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveMessage(@NotNull Message message, @Optional @Nullable LengthOfTime lifetime) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).isA(RequestAssertions.validMessage());
        this._saveMessage(message);
    }

    private final void _saveMessage(Message message) throws OperationFailedException {
        String statement = SQLStatements.Inserts.MESSAGE;
        try {
            this.serializer.save(message, statement, this.database);
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to serialize Message {} using statement [{}]", new Object[]{message, statement, ex});
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    @NotNull
    public Message getMessage(@NotNull String applicationId, @NotNull String messageId) throws TException {
        Message message;
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        UUID msgId = SQLPlusKt.toUUID(messageId);
        String statement = SQLStatements.Queries.SELECT_MESSAGE;
        try {
            message = (Message)this.database.queryForObject(statement, (RowMapper)this.serializer, new Object[]{appId, msgId});
        }
        catch (EmptyResultDataAccessException ex) {
            SQLMessageRepository.Companion.getLOG().warn("Message does not exist: [{}/{}]", new Object[]{appId, messageId, ex});
            throw (Throwable)new DoesNotExistException(ex.getMessage());
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to get message [{}/{}]", new Object[]{applicationId, messageId, ex});
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
        Arguments.checkThat((Object)message).throwing(DoesNotExistException.class).isA(Assertions.notNull());
        Message message2 = message;
        Intrinsics.checkExpressionValueIsNotNull((Object)message2, (String)"message");
        return message2;
    }

    @Override
    public void deleteMessage(@NotNull String applicationId, @NotNull String messageId) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        UUID msgId = SQLPlusKt.toUUID(messageId);
        String statement = SQLStatements.Deletes.MESSAGE;
        try {
            int updatedRows = this.database.update(statement, new Object[]{appId, msgId});
            SQLMessageRepository.Companion.getLOG().debug("{} rows affected deleting message [{}/{}]", new Object[]{updatedRows, applicationId, messageId});
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to delete message [{}/{}]", (Object)applicationId, (Object)messageId);
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    public boolean containsMessage(@NotNull String applicationId, @NotNull String messageId) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{messageId}).throwing(InvalidArgumentException.class).are(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        UUID msgId = SQLPlusKt.toUUID(messageId);
        String statement = SQLStatements.Queries.CHECK_MESSAGE;
        try {
            Object object = this.database.queryForObject(statement, Boolean.TYPE, new Object[]{appId, msgId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026class.java, appId, msgId)");
            return (Boolean)object;
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to check whether message exists: [{}/{}]", (Object)appId, (Object)msgId);
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    @NotNull
    public List<Message> getByHostname(@NotNull String hostname) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Arguments.checkThat((Object)hostname).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString());
        String statement = SQLStatements.Queries.SELECT_MESSAGES_BY_HOSTNAME;
        try {
            List list = this.database.query(statement, (RowMapper)this.serializer, new Object[]{hostname});
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.query(statement, serializer, hostname)");
            return list;
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to get all messages by hostname: [{}]", (Object)hostname, (Object)ex);
            throw (Throwable)new OperationFailedException("Coult not get all messages by hostname: " + hostname + " | " + ex.getMessage());
        }
    }

    @Override
    @NotNull
    public List<Message> getByApplication(@NotNull String applicationId) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).isA(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        String query = SQLStatements.Queries.SELECT_MESSAGES_BY_APPLICATION;
        try {
            List list = this.database.query(query, (RowMapper)this.serializer, new Object[]{appId});
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.query(query, serializer, appId)");
            return list;
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to get messages for Application: {}", (Object)appId, (Object)ex);
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    @NotNull
    public List<Message> getByTitle(@NotNull String applicationId, @NotNull String title) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Arguments.checkThat((Object)applicationId, (Object[])new String[]{title}).throwing(InvalidArgumentException.class).are(StringAssertions.nonEmptyString());
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).isA(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        String query = SQLStatements.Queries.SELECT_MESSAGES_BY_TITLE;
        try {
            List list = this.database.query(query, (RowMapper)this.serializer, new Object[]{appId, title});
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"database.query(query, serializer, appId, title)");
            return list;
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to query for messages by title [{}/{}]", (Object)applicationId, (Object)title);
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    public long getCountByApplication(@NotNull String applicationId) throws TException {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString()).isA(StringAssertions.validUUID());
        UUID appId = SQLPlusKt.toUUID(applicationId);
        String query = SQLStatements.Queries.COUNT_MESSAGES;
        try {
            Object object = this.database.queryForObject(query, Long.TYPE, new Object[]{appId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026 Long::class.java, appId)");
            return ((Number)object).longValue();
        }
        catch (Exception ex) {
            SQLMessageRepository.Companion.getLOG().error("Failed to determine the number of messages for App [{}]", (Object)applicationId);
            throw (Throwable)new OperationFailedException(ex.getMessage());
        }
    }

    @Inject
    public SQLMessageRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Message> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(SQLMessageRepository.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/SQLMessageRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

