/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.MediaRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.ImageType;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J \u0010!\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Ltech/aroma/data/sql/SQLMediaRepository;", "Ltech/aroma/data/MediaRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Image;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkDimensions", "", "dimension", "Ltech/aroma/thrift/Dimension;", "checkImage", "image", "checkMediaId", "id", "", "deleteAllThumbnails", "mediaId", "deleteMedia", "deleteThumbnail", "doesNotExist", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getMedia", "getThumbnail", "saveMedia", "saveThumbnail", "thumbnail", "Companion", "aroma-data-operations"})
public final class SQLMediaRepository
implements MediaRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Image> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveMedia(@NotNull String mediaId, @NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.checkMediaId(mediaId);
        this.checkImage(image);
        String sql = SQLStatements.Inserts.MEDIA;
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = SQLPlusKt.toUUID(mediaId);
            ImageType imageType = image.imageType;
            objectArray[1] = imageType != null ? imageType.toString() : null;
            Dimension dimension = image.dimension;
            objectArray[2] = dimension != null ? Integer.valueOf(dimension.width) : null;
            Dimension dimension2 = image.dimension;
            objectArray[3] = dimension2 != null ? Integer.valueOf(dimension2.height) : null;
            objectArray[4] = image.getData();
            this.database.update(sql, objectArray);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not save image", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public Image getMedia(@NotNull String mediaId) {
        Image image;
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        this.checkMediaId(mediaId);
        String sql = SQLStatements.Queries.SELECT_MEDIA;
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(mediaId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026alizer, mediaId.toUUID())");
            image = (Image)object;
        }
        catch (EmptyResultDataAccessException ex) {
            Void void_ = SQLMediaRepository.doesNotExist$default(this, mediaId, null, (Exception)((Object)ex), 2, null);
            throw null;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not extract Media with ID [" + mediaId + "]", ex);
            throw null;
        }
        return image;
    }

    @Override
    public void deleteMedia(@NotNull String mediaId) {
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        this.checkMediaId(mediaId);
        String sql = SQLStatements.Deletes.MEDIA;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(mediaId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not delete Media with ID [" + mediaId + "]", ex);
            throw null;
        }
    }

    @Override
    public void saveThumbnail(@NotNull String mediaId, @NotNull Dimension dimension, @NotNull Image thumbnail) {
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"dimension");
        Intrinsics.checkParameterIsNotNull((Object)thumbnail, (String)"thumbnail");
        this.checkMediaId(mediaId);
        this.checkImage(thumbnail);
        this.checkDimensions(dimension);
        String sql = SQLStatements.Inserts.MEDIA_THUMBNAIL;
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = SQLPlusKt.toUUID(mediaId);
            objectArray[1] = dimension.width;
            objectArray[2] = dimension.height;
            ImageType imageType = thumbnail.imageType;
            objectArray[3] = imageType != null ? imageType.toString() : null;
            objectArray[4] = thumbnail.getData();
            this.database.update(sql, objectArray);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not save Thumbnail: [" + mediaId + " -" + dimension, ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public Image getThumbnail(@NotNull String mediaId, @NotNull Dimension dimension) {
        Image image;
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"dimension");
        this.checkMediaId(mediaId);
        this.checkDimensions(dimension);
        String sql = SQLStatements.Queries.SELECT_MEDIA_THUMBNAIL;
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(mediaId), dimension.width, dimension.height});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026        dimension.height)");
            image = (Image)object;
        }
        catch (EmptyResultDataAccessException ex) {
            Void void_ = this.doesNotExist(mediaId, dimension, (Exception)((Object)ex));
            throw null;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not get thumbnail: [" + mediaId + "/" + dimension + "]", ex);
            throw null;
        }
        return image;
    }

    @Override
    public void deleteThumbnail(@NotNull String mediaId, @NotNull Dimension dimension) {
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"dimension");
        this.checkMediaId(mediaId);
        this.checkDimensions(dimension);
        String sql = SQLStatements.Deletes.MEDIA_THUMBNAIL;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(mediaId), dimension.width, dimension.height});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not Delete thumbnail: [" + mediaId + " | " + dimension + "]", ex);
            throw null;
        }
    }

    @Override
    public void deleteAllThumbnails(@NotNull String mediaId) {
        Intrinsics.checkParameterIsNotNull((Object)mediaId, (String)"mediaId");
        this.checkMediaId(mediaId);
        String sql = SQLStatements.Deletes.ALL_MEDIA_THUMBNAILS;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(mediaId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not delete all thumbnails for [" + mediaId + "]", ex);
            throw null;
        }
    }

    private final void checkMediaId(String id) {
        Arguments.checkThat((Object)id).throwing(InvalidArgumentException.class).usingMessage("invalid Media ID: [" + id + "]").isA(StringAssertions.validUUID());
    }

    private final void checkImage(Image image) {
        Arguments.checkThat((Object)image).throwing(InvalidArgumentException.class).isA(RequestAssertions.validImage());
    }

    private final void checkDimensions(Dimension dimension) {
        Arguments.checkThat((Object)dimension.width).throwing(InvalidArgumentException.class).usingMessage("invalid width").isA(NumberAssertions.positiveInteger());
        Arguments.checkThat((Object)dimension.height).throwing(InvalidArgumentException.class).usingMessage("invalid height").isA(NumberAssertions.positiveInteger());
    }

    private final Void doesNotExist(String mediaId, Dimension dimension, Exception ex) {
        String message = "Media item with ID [" + mediaId + "]";
        if (dimension != null) {
            message = message + (" and dimension " + dimension);
        }
        message = message + " does not exist";
        Companion.getLOG().warn(message, (Throwable)ex);
        throw (Throwable)new DoesNotExistException(message + " | " + ex.getMessage());
    }

    static /* bridge */ /* synthetic */ Void doesNotExist$default(SQLMediaRepository sQLMediaRepository, String string, Dimension dimension, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            dimension = null;
        }
        return sQLMediaRepository.doesNotExist(string, dimension, exception);
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Image> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLMediaRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Image> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ltech/aroma/data/sql/SQLMediaRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

