/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.omg.CORBA.DynAnyPackage.Invalid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.InboxRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.data.sql.Timestamps;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.Message;
import tech.aroma.thrift.Urgency;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Ltech/aroma/data/sql/SQLInboxRepository;", "Ltech/aroma/data/InboxRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Message;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "containsMessageInInbox", "", "userId", "", "message", "countInboxForUser", "", "deleteAllMessagesForUser", "", "deleteMessageForUser", "messageId", "getMessagesForUser", "", "saveMessageForUser", "user", "Ltech/aroma/thrift/User;", "lifetime", "Ltech/aroma/thrift/LengthOfTime;", "tryToSaveMessage", "Companion", "aroma-data-operations"})
public final class SQLInboxRepository
implements InboxRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Message> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveMessageForUser(@NotNull User user, @NotNull Message message, @NotNull LengthOfTime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUser());
        Arguments.checkThat((Object)message).throwing(InvalidArgumentException.class).isA(RequestAssertions.validMessage());
        this.tryToSaveMessage(user, message);
    }

    private final void tryToSaveMessage(User user, Message message) {
        String sql = SQLStatements.Inserts.INBOX_MESSAGE;
        Object object = user.userId;
        if (object == null || (object = SQLPlusKt.toUUID((String)object)) == null) {
            throw (Throwable)new Invalid("missing user_id");
        }
        Object userId = object;
        UUID uUID = SQLPlusKt.toUUID(message.applicationId);
        if (uUID == null) {
            throw (Throwable)new InvalidArgumentException("missing app_id");
        }
        UUID appId = uUID;
        UUID uUID2 = SQLPlusKt.toUUID(message.messageId);
        if (uUID2 == null) {
            throw (Throwable)new InvalidArgumentException("missing message_id");
        }
        UUID messageId = uUID2;
        Timestamp timeCreated = message.timeOfCreation > (long)0 ? SQLPlusKt.toTimestamp(message.timeOfCreation) : Timestamps.INSTANCE.now();
        Timestamp timeReceived = message.timeMessageReceived > (long)0 ? SQLPlusKt.toTimestamp(message.timeMessageReceived) : Timestamps.INSTANCE.now();
        try {
            Object[] objectArray = new Object[12];
            objectArray[0] = userId;
            objectArray[1] = messageId;
            objectArray[2] = appId;
            objectArray[3] = message.applicationName;
            objectArray[4] = message.title;
            objectArray[5] = message.body;
            Urgency urgency = message.urgency;
            objectArray[6] = urgency != null ? urgency.toString() : null;
            objectArray[7] = timeCreated;
            objectArray[8] = timeReceived;
            objectArray[9] = message.hostname;
            objectArray[10] = message.macAddress;
            objectArray[11] = message.deviceName;
            this.database.update(sql, objectArray);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save message in inbox of user [" + userId + "] | [" + message + "]", ex);
            throw null;
        }
    }

    @Override
    @NotNull
    public List<Message> getMessagesForUser(@NotNull String userId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.SELECT_INBOX_MESSAGES_FOR_USER;
        try {
            List list2 = this.database.query(sql, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(sql, serializer, userId.toUUID())");
            list = list2;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to find inbox messages for user [" + userId + "]", ex);
            throw null;
        }
        return list;
    }

    @Override
    public boolean containsMessageInInbox(@NotNull String userId, @NotNull Message message) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        RepositoriesPlusKt.checkUserId(userId);
        RepositoriesPlusKt.checkMessageId(message.messageId);
        String sql = SQLStatements.Queries.CHECK_INBOX_MESSAGE;
        UUID uUID = SQLPlusKt.toUUID(userId);
        if (uUID == null) {
            Intrinsics.throwNpe();
        }
        UUID userId2 = uUID;
        UUID uUID2 = SQLPlusKt.toUUID(message.messageId);
        if (uUID2 == null) {
            Intrinsics.throwNpe();
        }
        UUID messageId = uUID2;
        try {
            Object object = this.database.queryForObject(sql, Boolean.TYPE, new Object[]{userId2, messageId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026.java, userId, messageId)");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to check if message [" + messageId + "] exists for user [" + userId2 + "]", ex);
            throw null;
        }
        return bl;
    }

    @Override
    public void deleteMessageForUser(@NotNull String userId, @NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        RepositoriesPlusKt.checkUserId(userId);
        RepositoriesPlusKt.checkMessageId(messageId);
        String sql = SQLStatements.Deletes.INBOX_MESSAGE;
        try {
            int updated = this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId), SQLPlusKt.toUUID(messageId)});
            Companion.getLOG().debug("Operation to delete inbox message [" + userId + "/" + messageId + "] resulted in " + updated + " rows updated");
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete inbox message [" + userId + "/" + messageId + "]", ex);
            throw null;
        }
    }

    @Override
    public void deleteAllMessagesForUser(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Deletes.INBOX_ALL_MESSAGES;
        try {
            int updated = this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId)});
            Companion.getLOG().debug("Operation to delete all messages for [" + userId + "] deleted " + updated + " rows");
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete all messages for user [" + userId + "]", ex);
            throw null;
        }
    }

    @Override
    public long countInboxForUser(@NotNull String userId) {
        Long l;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.COUNT_INBOX_MESSAGES;
        try {
            Object object = this.database.queryForObject(sql, Long.TYPE, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ss.java, userId.toUUID())");
            l = (Long)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to count inbox messages for user [" + userId + "]", ex);
            throw null;
        }
        return l;
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Message> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLInboxRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Message> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    public static final Logger getLOG() {
        return Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ltech/aroma/data/sql/SQLInboxRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        public static /* synthetic */ void LOG$annotations() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

