/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001c"}, d2={"Ltech/aroma/data/sql/SQLFollowerRepository;", "Ltech/aroma/data/FollowerRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "appSerializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Application;", "userSerializer", "Ltech/aroma/thrift/User;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getAppSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getUserSerializer", "deleteFollowing", "", "userId", "", "applicationId", "followingExists", "", "getApplicationFollowers", "", "getApplicationsFollowedBy", "saveFollowing", "user", "application", "aroma-data-operations"})
public final class SQLFollowerRepository
implements FollowerRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Application> appSerializer;
    @NotNull
    private final DatabaseSerializer<User> userSerializer;

    @Override
    public void saveFollowing(@NotNull User user, @NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        RepositoriesPlusKt.checkUserId(user.userId);
        RepositoriesPlusKt.checkAppId(application.applicationId);
        Object object = user.userId;
        if (object == null || (object = SQLPlusKt.toUUID((String)object)) == null) {
            throw (Throwable)new InvalidArgumentException("Invalid userId: " + user);
        }
        Object userId = object;
        Object object2 = application.applicationId;
        if (object2 == null || (object2 = SQLPlusKt.toUUID((String)object2)) == null) {
            throw (Throwable)new InvalidArgumentException("Invalid appId: " + application);
        }
        Object appId = object2;
        String sql = SQLStatements.Inserts.FOLLOWING;
        try {
            this.database.update(sql, new Object[]{appId, userId});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not save following for User[" + userId + "] and App[" + appId + "]", ex);
            throw null;
        }
    }

    @Override
    public void deleteFollowing(@NotNull String userId, @NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkUserId(userId);
        RepositoriesPlusKt.checkAppId(applicationId);
        String sql = SQLStatements.Deletes.FOLLOWING;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(applicationId), SQLPlusKt.toUUID(userId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not delete following for User[" + userId + "] and App[" + applicationId, ex);
            throw null;
        }
    }

    @Override
    public boolean followingExists(@NotNull String userId, @NotNull String applicationId) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkUserId(userId);
        RepositoriesPlusKt.checkAppId(applicationId);
        String sql = SQLStatements.Queries.CHECK_FOLLOWING_EXISTS;
        try {
            Object object = this.database.queryForObject(sql, Boolean.TYPE, new Object[]{SQLPlusKt.toUUID(applicationId), SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026oUUID(), userId.toUUID())");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not check if user [" + userId + "] follows App[" + applicationId + "]", ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public List<Application> getApplicationsFollowedBy(@NotNull String userId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.SELECT_APPS_FOLLOWING;
        try {
            List list2 = this.database.query(sql, (RowMapper)this.appSerializer, new Object[]{SQLPlusKt.toUUID(userId)});
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list = list2;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not determine apps being followed by User[" + userId + "]", ex);
            throw null;
        }
        return list;
    }

    @Override
    @NotNull
    public List<User> getApplicationFollowers(@NotNull String applicationId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkAppId(applicationId);
        String sql = SQLStatements.Queries.SELECT_APP_FOLLOWERS;
        try {
            List list2 = this.database.query(sql, (RowMapper)this.userSerializer, new Object[]{SQLPlusKt.toUUID(applicationId)});
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list = list2;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not determine who follows App [" + applicationId + "]", ex);
            throw null;
        }
        return list;
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Application> getAppSerializer() {
        return this.appSerializer;
    }

    @NotNull
    public final DatabaseSerializer<User> getUserSerializer() {
        return this.userSerializer;
    }

    @Inject
    public SQLFollowerRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Application> appSerializer, @NotNull DatabaseSerializer<User> userSerializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(appSerializer, (String)"appSerializer");
        Intrinsics.checkParameterIsNotNull(userSerializer, (String)"userSerializer");
        this.database = database;
        this.appSerializer = appSerializer;
        this.userSerializer = userSerializer;
    }
}

