/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import tech.aroma.data.CredentialRepository;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ltech/aroma/data/sql/SQLCredentialRepository;", "Ltech/aroma/data/CredentialRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "(Lorg/springframework/jdbc/core/JdbcOperations;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "containsEncryptedPassword", "", "userId", "", "deleteEncryptedPassword", "", "getEncryptedPassword", "saveEncryptedPassword", "encryptedPassword", "aroma-data-operations"})
public final class SQLCredentialRepository
implements CredentialRepository {
    @NotNull
    private final JdbcOperations database;

    @Override
    public void saveEncryptedPassword(@NotNull String userId, @NotNull String encryptedPassword) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)encryptedPassword, (String)"encryptedPassword");
        RepositoriesPlusKt.checkUserId(userId);
        Arguments.checkThat((Object)encryptedPassword).throwing(InvalidArgumentException.class).isA(StringAssertions.nonEmptyString());
        String sql = SQLStatements.Inserts.CREDENTIAL;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId), encryptedPassword});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save encrypted password for [" + userId + "]", ex);
            throw null;
        }
    }

    @Override
    public boolean containsEncryptedPassword(@NotNull String userId) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.CHECK_CREDENTIAL;
        try {
            Object object = this.database.queryForObject(sql, Boolean.TYPE, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ss.java, userId.toUUID())");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not check if user has password: [" + userId + "]", ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getEncryptedPassword(@NotNull String userId) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Queries.SELECT_CREDENTIAL;
        try {
            Object object = this.database.queryForObject(sql, String.class, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ss.java, userId.toUUID())");
            string = (String)object;
        }
        catch (EmptyResultDataAccessException ex) {
            throw (Throwable)new DoesNotExistException("No credentials found for [" + userId + "]");
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Could not get user password: [" + userId + "]", ex);
            throw null;
        }
        return string;
    }

    @Override
    public void deleteEncryptedPassword(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String sql = SQLStatements.Deletes.CREDENTIAL;
        try {
            this.database.update(sql, new Object[]{SQLPlusKt.toUUID(userId)});
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to delete credentials for User [" + userId + "]", ex);
            throw null;
        }
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @Inject
    public SQLCredentialRepository(@NotNull JdbcOperations database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.database = database;
    }
}

