/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0006H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Ltech/aroma/data/sql/SQLApplicationRepository;", "Ltech/aroma/data/ApplicationRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/Application;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkOrgId", "", "orgId", "", "checkSearchTerm", "searchTerm", "containsApplication", "", "applicationId", "deleteApplication", "getApplicationsByOrg", "", "getApplicationsOwnedBy", "userId", "getById", "getRecentlyCreated", "insertOwner", "appId", "owner", "saveApplication", "application", "searchByName", "tryToRestoreApp", "app", "updateAppOwnersFor", "aroma-data-operations"})
public final class SQLApplicationRepository
implements ApplicationRepository {
    private final Logger LOG;
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Application> serializer;

    @Override
    public void saveApplication(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Arguments.checkThat((Object)application).throwing(InvalidArgumentException.class).isA(RequestAssertions.validApplication());
        String insertApp = SQLStatements.Inserts.APPLICATION;
        try {
            this.serializer.save(application, insertApp, this.database);
        }
        catch (Exception ex) {
            Void void_ = RepositoriesPlusKt.failWithMessage("Failed to save Application [" + application + "] in Database", ex);
            throw null;
        }
        this.updateAppOwnersFor(application);
    }

    private final void updateAppOwnersFor(Application app) {
        String appId = app.applicationId;
        Iterable $receiver$iv = app.owners;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            String string = appId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appId");
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            this.insertOwner(string, string2);
        }
        String deleteNonOwnersSQL = SQLStatements.Deletes.APPLICATION_NON_OWNERS;
        try {
            this.database.update(deleteNonOwnersSQL, new Object[]{SQLPlusKt.toUUID(appId), SQLPlusKt.toCommaSeparatedList(app.owners)});
        }
        catch (Exception ex) {
            String message = "Failed to remove all non-owners for App [" + appId + "]";
            this.LOG.warn(message, (Throwable)ex);
        }
    }

    private final void insertOwner(String appId, String owner) {
        String insertOwner = SQLStatements.Inserts.APPLICATION_OWNER;
        try {
            this.database.update(insertOwner, new Object[]{SQLPlusKt.toUUID(appId), SQLPlusKt.toUUID(owner)});
        }
        catch (Exception ex) {
            String message = "Failed to save Owner [" + owner + "] for App [" + appId + "]";
            this.LOG.warn(message, (Throwable)ex);
        }
    }

    @Override
    public void deleteApplication(@NotNull String applicationId) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkAppId(applicationId);
        Application app = this.getById(applicationId);
        String deleteAppSQL = SQLStatements.Deletes.APPLICATION;
        String deleteOwnersSQL = SQLStatements.Deletes.APPLICATION_OWNERS;
        UUID appId = SQLPlusKt.toUUID(applicationId);
        try {
            this.database.update(deleteAppSQL, new Object[]{appId});
            this.database.update(deleteOwnersSQL, new Object[]{appId});
        }
        catch (Exception ex) {
            this.tryToRestoreApp(app);
            String message = "Failed to delete Application: [" + appId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
    }

    private final void tryToRestoreApp(Application app) {
        try {
            this.saveApplication(app);
        }
        catch (Exception ex) {
            this.LOG.error("Failed to restore App [" + app + "]", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public Application getById(@NotNull String applicationId) {
        Application application;
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkAppId(applicationId);
        String query = SQLStatements.Queries.SELECT_APPLICATION;
        UUID appId = SQLPlusKt.toUUID(applicationId);
        try {
            Object object = this.database.queryForObject(query, (RowMapper)this.serializer, new Object[]{appId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(query, serializer, appId)");
            application = (Application)object;
        }
        catch (EmptyResultDataAccessException ex) {
            String message = "No such App with ID: " + appId;
            this.LOG.warn(message, (Throwable)ex);
            throw (Throwable)new DoesNotExistException(message + " | " + ex.getMessage());
        }
        catch (Exception ex) {
            String message = "Failed to find an App by ID [" + appId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return application;
    }

    @Override
    public boolean containsApplication(@NotNull String applicationId) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        RepositoriesPlusKt.checkAppId(applicationId);
        String query = SQLStatements.Queries.CHECK_APPLICATION;
        UUID appId = SQLPlusKt.toUUID(applicationId);
        try {
            Object object = this.database.queryForObject(query, Boolean.TYPE, new Object[]{appId});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026olean::class.java, appId)");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            String message = "Failed to check if App exists: [" + appId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public List<Application> getApplicationsOwnedBy(@NotNull String userId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        RepositoriesPlusKt.checkUserId(userId);
        String query = SQLStatements.Queries.SELECT_APPLICATION_BY_OWNER;
        try {
            List list2 = this.database.query(query, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(userId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(query, serializer, userId.toUUID())");
            list = list2;
        }
        catch (Exception ex) {
            String message = "Could not query database for apps owned by [" + userId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    @Override
    @NotNull
    public List<Application> getApplicationsByOrg(@NotNull String orgId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)orgId, (String)"orgId");
        this.checkOrgId(orgId);
        String query = SQLStatements.Queries.SELECT_APPLICATION_BY_ORGANIZATION;
        try {
            List list2 = this.database.query(query, (RowMapper)this.serializer, new Object[]{SQLPlusKt.toUUID(orgId)});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(query, serializer, orgId.toUUID())");
            list = list2;
        }
        catch (Exception ex) {
            String message = "Failed to get applications by Org: [" + orgId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    @Override
    @NotNull
    public List<Application> searchByName(@NotNull String searchTerm) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        this.checkSearchTerm(searchTerm);
        String query = SQLStatements.Queries.SEARCH_APPLICATION_BY_NAME;
        String token = "%" + searchTerm + "%";
        try {
            List list2 = this.database.query(query, (RowMapper)this.serializer, new Object[]{token});
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(query, serializer, token)");
            list = list2;
        }
        catch (Exception ex) {
            String message = "Failed to search for Apps with term: [" + searchTerm + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    @Override
    @NotNull
    public List<Application> getRecentlyCreated() {
        List list;
        String query = SQLStatements.Queries.SELECT_RECENT_APPLICATION;
        try {
            List list2 = this.database.query(query, (RowMapper)this.serializer);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"database.query(query, serializer)");
            list = list2;
        }
        catch (Exception ex) {
            String message = "Failed to query for recently created apps";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    private final void checkOrgId(String orgId) {
        Arguments.checkThat((Object)orgId).throwing(InvalidArgumentException.class).usingMessage("Invalid Org ID: " + orgId).isA(StringAssertions.nonEmptyString()).isA(StringAssertions.validUUID());
    }

    private final void checkSearchTerm(String searchTerm) {
        Arguments.checkThat((Object)searchTerm).throwing(InvalidArgumentException.class).usingMessage("Search term cannot be empty").isA(StringAssertions.nonEmptyString()).usingMessage("Search term must have at least 2 characters").isA(StringAssertions.stringWithLengthGreaterThanOrEqualTo((int)2));
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Application> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLApplicationRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Application> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

