/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import tech.aroma.data.ActivityRepository;
import tech.aroma.data.sql.DatabaseSerializer;
import tech.aroma.data.sql.RepositoriesPlusKt;
import tech.aroma.data.sql.SQLPlusKt;
import tech.aroma.data.sql.SQLStatements;
import tech.aroma.data.sql.Timestamps;
import tech.aroma.thrift.LengthOfTime;
import tech.aroma.thrift.User;
import tech.aroma.thrift.events.Event;
import tech.aroma.thrift.events.EventType;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.AlchemyAssertion;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;
import tech.sirwellington.alchemy.thrift.ThriftObjects;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Ltech/aroma/data/sql/SQLActivityRepository;", "Ltech/aroma/data/ActivityRepository;", "database", "Lorg/springframework/jdbc/core/JdbcOperations;", "serializer", "Ltech/aroma/data/sql/DatabaseSerializer;", "Ltech/aroma/thrift/events/Event;", "(Lorg/springframework/jdbc/core/JdbcOperations;Ltech/aroma/data/sql/DatabaseSerializer;)V", "getDatabase", "()Lorg/springframework/jdbc/core/JdbcOperations;", "getSerializer", "()Ltech/aroma/data/sql/DatabaseSerializer;", "checkEventId", "", "eventId", "", "containsEvent", "", "user", "Ltech/aroma/thrift/User;", "deleteAllEventsFor", "deleteEvent", "getAllEventsFor", "", "getEvent", "saveEvent", "event", "forUser", "lifetime", "Ltech/aroma/thrift/LengthOfTime;", "Companion", "aroma-data-operations"})
public final class SQLActivityRepository
implements ActivityRepository {
    @NotNull
    private final JdbcOperations database;
    @NotNull
    private final DatabaseSerializer<Event> serializer;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void saveEvent(@NotNull Event event, @NotNull User forUser, @Nullable LengthOfTime lifetime) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)forUser, (String)"forUser");
        this.checkEventId(event.eventId);
        User user = forUser;
        RepositoriesPlusKt.checkUser(user);
        UUID recepientId = SQLPlusKt.toUUID(user.userId);
        UUID eventId = SQLPlusKt.toUUID(event.eventId);
        UUID appId = SQLPlusKt.toUUID(event.applicationId);
        UUID actorId = SQLPlusKt.toUUID(event.userIdOfActor);
        try {
            string = ThriftObjects.toJson((TBase)((TBase)event));
        }
        catch (Exception ex) {
            String message = "Failed to serialize event [" + event + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        String serialized = string;
        EventType eventType = event.eventType;
        String eventType2 = eventType != null ? eventType.toString() : null;
        Timestamp timestamp = event.timestamp > (long)0 ? SQLPlusKt.toTimestamp(event.timestamp) : Timestamps.INSTANCE.now();
        String sql = SQLStatements.Inserts.ACTIVITY_EVENT;
        try {
            this.database.update(sql, new Object[]{recepientId, eventId, appId, actorId, timestamp, eventType2, serialized});
        }
        catch (Exception ex) {
            String message = "Failed to save event [" + event + "] for user [" + recepientId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
    }

    @Override
    public boolean containsEvent(@NotNull String eventId, @NotNull User user) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.checkEventId(eventId);
        RepositoriesPlusKt.checkUser(user);
        UUID eventId2 = SQLPlusKt.toUUID(eventId);
        UUID userId = SQLPlusKt.toUUID(user.userId);
        String sql = SQLStatements.Queries.CHECK_ACTIVITY_EVENT;
        try {
            Object object = this.database.queryForObject(sql, Boolean.TYPE, new Object[]{userId, eventId2});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ss.java, userId, eventId)");
            bl = (Boolean)object;
        }
        catch (Exception ex) {
            String message = "Failed to check if event exists: [" + userId + "/" + eventId2 + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return bl;
    }

    @Override
    @NotNull
    public Event getEvent(@NotNull String eventId, @NotNull User user) {
        Event event;
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.checkEventId(eventId);
        RepositoriesPlusKt.checkUser(user);
        String sql = SQLStatements.Queries.SELECT_ACTIVITY_EVENT;
        UUID eventId2 = SQLPlusKt.toUUID(eventId);
        UUID userId = SQLPlusKt.toUUID(user.userId);
        try {
            Object object = this.database.queryForObject(sql, (RowMapper)this.serializer, new Object[]{userId, eventId2});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"database.queryForObject(\u2026ializer, userId, eventId)");
            event = (Event)object;
        }
        catch (EmptyResultDataAccessException ex) {
            String message = "Activity Event does not exist: [" + userId + "/" + eventId2 + "]";
            SQLActivityRepository.Companion.getLOG().warn(message, (Throwable)ex);
            throw (Throwable)new DoesNotExistException(message);
        }
        catch (Exception ex) {
            String message = "Failed to get event [" + userId + "/" + eventId2 + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return event;
    }

    @Override
    @NotNull
    public List<Event> getAllEventsFor(@NotNull User user) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        RepositoriesPlusKt.checkUser(user);
        UUID userId = SQLPlusKt.toUUID(user.userId);
        String sql = SQLStatements.Queries.SELECT_ALL_ACTIVITY_FOR_USER;
        try {
            List list2 = this.database.query(sql, (RowMapper)this.serializer, new Object[]{userId});
            if (list2 == null) {
                list2 = new ArrayList();
            }
            list = list2;
        }
        catch (Exception ex) {
            String message = "Failed to get all events for user [" + userId + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
        return list;
    }

    @Override
    public void deleteEvent(@NotNull String eventId, @NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.checkEventId(eventId);
        RepositoriesPlusKt.checkUser(user);
        UUID userId = SQLPlusKt.toUUID(user.userId);
        UUID eventId2 = SQLPlusKt.toUUID(eventId);
        String sql = SQLStatements.Deletes.ACTIVITY_EVENT;
        try {
            int deleted = this.database.update(sql, new Object[]{userId, eventId2});
            SQLActivityRepository.Companion.getLOG().debug("Operation to delete activity [" + userId + "/" + eventId2 + "] affected " + deleted + " rows");
        }
        catch (Exception ex) {
            String message = "Failed to delete Activity Event [" + userId + "/" + eventId2 + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
    }

    @Override
    public void deleteAllEventsFor(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        RepositoriesPlusKt.checkUser(user);
        UUID userId = SQLPlusKt.toUUID(user.userId);
        String sql = SQLStatements.Deletes.ACTIVITY_ALL_EVENTS;
        try {
            int deleted = this.database.update(sql, new Object[]{userId});
            SQLActivityRepository.Companion.getLOG().debug("Operation to clear Activity for user [" + userId + "] affected " + deleted + " rows");
        }
        catch (Exception ex) {
            String message = "Failed to delete all messages for user [" + user + "]";
            Void void_ = RepositoriesPlusKt.failWithMessage(message, ex);
            throw null;
        }
    }

    private final void checkEventId(String eventId) {
        AlchemyAssertion alchemyAssertion = StringAssertions.validUUID();
        if (alchemyAssertion == null) {
            throw new TypeCastException("null cannot be cast to non-null type tech.sirwellington.alchemy.arguments.AlchemyAssertion<kotlin.String?>");
        }
        Arguments.checkThat((Object)eventId).throwing(InvalidArgumentException.class).usingMessage("Invalid Event ID : " + eventId).isA(alchemyAssertion);
    }

    @NotNull
    public final JdbcOperations getDatabase() {
        return this.database;
    }

    @NotNull
    public final DatabaseSerializer<Event> getSerializer() {
        return this.serializer;
    }

    @Inject
    public SQLActivityRepository(@NotNull JdbcOperations database, @NotNull DatabaseSerializer<Event> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.database = database;
        this.serializer = serializer;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    private static final Logger getLOG() {
        return SQLActivityRepository.Companion.getLOG();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltech/aroma/data/sql/SQLActivityRepository$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "LOG$annotations", "getLOG", "()Lorg/slf4j/Logger;", "aroma-data-operations"})
    private static final class Companion {
        @JvmStatic
        private static /* synthetic */ void LOG$annotations() {
        }

        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

