/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.data.sql.LOG;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.OperationFailedException;
import tech.sirwellington.alchemy.arguments.Arguments;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0000\u00a8\u0006\u0014"}, d2={"checkAppId", "", "appId", "", "checkApplication", "app", "Ltech/aroma/thrift/Application;", "checkMessageId", "messageId", "checkUser", "user", "Ltech/aroma/thrift/User;", "checkUserId", "userId", "failWithMessage", "", "message", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "aroma-data-operations"})
public final class RepositoriesPlusKt {
    @NotNull
    public static final Void failWithMessage(@NotNull String message, @NotNull Exception ex) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        LOG.INSTANCE.error(message, ex);
        throw (Throwable)new OperationFailedException(message + " | " + ex.getMessage());
    }

    public static final void checkApplication(@Nullable Application app) {
        Arguments.checkThat((Object)app).throwing(InvalidArgumentException.class).isA(RequestAssertions.validApplication());
    }

    public static final void checkAppId(@Nullable String appId) {
        Arguments.checkThat((Object)appId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validApplicationId());
    }

    public static final void checkMessageId(@Nullable String messageId) {
        Arguments.checkThat((Object)messageId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validMessageId());
    }

    public static final void checkUser(@Nullable User user) {
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUser());
    }

    public static final void checkUserId(@Nullable String userId) {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).isA(RequestAssertions.validUserId());
    }
}

