/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.performance;

import decorice.DecoratedBy;
import java.util.List;
import javax.inject.Inject;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.thrift.Application;
import tech.sirwellington.alchemy.annotations.designs.patterns.DecoratorPattern;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;

@DecoratorPattern(role=DecoratorPattern.Role.DECORATOR)
public final class MeasuredApplicationRepository
implements ApplicationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MeasuredApplicationRepository.class);
    private final ApplicationRepository delegate;

    @Inject
    public MeasuredApplicationRepository(@DecoratedBy(value=MeasuredApplicationRepository.class) ApplicationRepository delegate) {
        Arguments.checkThat((Object)delegate).is(Assertions.notNull());
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveApplication(Application application) throws TException {
        long start = System.currentTimeMillis();
        try {
            this.delegate.saveApplication(application);
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("saveApplication Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplication(String applicationId) throws TException {
        long start = System.currentTimeMillis();
        try {
            this.delegate.deleteApplication(applicationId);
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("deleteApplication Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application getById(String applicationId) throws TException {
        long start = System.currentTimeMillis();
        try {
            Application application = this.delegate.getById(applicationId);
            return application;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("getById Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsApplication(String applicationId) throws TException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = this.delegate.containsApplication(applicationId);
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("containsApplication Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getApplicationsOwnedBy(String userId) throws TException {
        long start = System.currentTimeMillis();
        try {
            List<Application> list = this.delegate.getApplicationsOwnedBy(userId);
            return list;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("getApplicationsOwnedBy Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getApplicationsByOrg(String orgId) throws TException {
        long start = System.currentTimeMillis();
        try {
            List<Application> list = this.delegate.getApplicationsByOrg(orgId);
            return list;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("getApplicationsByOrg Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> searchByName(String searchTerm) throws TException {
        long start = System.currentTimeMillis();
        try {
            List<Application> list = this.delegate.searchByName(searchTerm);
            return list;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("searchByName Operation took {} ms", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getRecentlyCreated() throws TException {
        long start = System.currentTimeMillis();
        try {
            List<Application> list = this.delegate.getRecentlyCreated();
            return list;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.debug("getRecentlyCreated Operation took {} ms", (Object)(end - start));
        }
    }
}

