/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.maps.Maps;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.UserPreferencesRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.channels.MobileDevice;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.ThreadSafe;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.BooleanAssertions;

@Internal
@ThreadSafe
final class MemoryUserPreferencesRepository
implements UserPreferencesRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryUserPreferencesRepository.class);
    private final Map<String, Set<MobileDevice>> devices = Maps.createSynchronized();

    MemoryUserPreferencesRepository() {
    }

    @Override
    public void saveMobileDevice(String userId, MobileDevice mobileDevice) throws TException {
        this.checkUserId(userId);
        this.checkMobileDevice(mobileDevice);
        Set<MobileDevice> userDevices = this.devices.getOrDefault(userId, Sets.create());
        userDevices.add(mobileDevice);
        this.devices.put(userId, userDevices);
    }

    @Override
    public void saveMobileDevices(String userId, Set<MobileDevice> mobileDevices) throws TException {
        this.checkUserId(userId);
        this.checkDevices(mobileDevices);
        this.devices.put(userId, mobileDevices);
    }

    @Override
    public Set<MobileDevice> getMobileDevices(String userId) throws TException {
        this.checkUserId(userId);
        return this.devices.getOrDefault(userId, Sets.emptySet());
    }

    @Override
    public void deleteMobileDevice(String userId, MobileDevice mobileDevice) throws TException {
        this.checkUserId(userId);
        this.checkMobileDevice(mobileDevice);
        Set filteredDevices = this.devices.getOrDefault(userId, Sets.emptySet()).stream().filter(device -> !Objects.equals(device, mobileDevice)).collect(Collectors.toSet());
        this.devices.put(userId, filteredDevices);
    }

    @Override
    public void deleteAllMobileDevices(String userId) throws TException {
        this.checkUserId(userId);
        this.devices.remove(userId);
    }

    private void checkMobileDevice(MobileDevice mobileDevice) throws InvalidArgumentException {
        Arguments.checkThat((Object)mobileDevice).throwing(InvalidArgumentException.class).usingMessage("MobileDevice cannot be null").is(Assertions.notNull());
        Arguments.checkThat((Object)mobileDevice.isSet()).throwing(InvalidArgumentException.class).usingMessage("Mobiel Device must be set").is(BooleanAssertions.trueStatement());
    }

    private void checkUserId(String userId) throws InvalidArgumentException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
    }

    private void checkDevices(Set<MobileDevice> mobileDevices) throws InvalidArgumentException {
        Arguments.checkThat(mobileDevices).throwing(InvalidArgumentException.class).usingMessage("Set of Mobile Devices cannot be null").is(Assertions.notNull());
        for (MobileDevice device : mobileDevices) {
            this.checkMobileDevice(device);
        }
    }
}

