/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.ReactionRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.reactions.Reaction;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;

@Internal
final class MemoryReactionRepository
implements ReactionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryReactionRepository.class);
    private final Map<String, List<Reaction>> database = Maps.createSynchronized();

    MemoryReactionRepository() {
    }

    @Override
    public void saveReactionsForUser(String userId, List<Reaction> reactions) throws TException {
        this.checkUserId(userId);
        if (Lists.isEmpty(reactions)) {
            this.database.remove(userId);
            return;
        }
        this.database.put(userId, reactions);
    }

    @Override
    public List<Reaction> getReactionsForUser(String userId) throws TException {
        this.checkUserId(userId);
        return this.database.getOrDefault(userId, Lists.emptyList());
    }

    @Override
    public void saveReactionsForApplication(String appId, List<Reaction> reactions) throws TException {
        this.checkAppId(appId);
        if (Lists.isEmpty(reactions)) {
            this.database.remove(appId);
            return;
        }
        this.database.put(appId, reactions);
    }

    @Override
    public List<Reaction> getReactionsForApplication(String appId) throws TException {
        this.checkAppId(appId);
        return this.database.getOrDefault(appId, Lists.emptyList());
    }

    private void checkUserId(String userId) throws InvalidArgumentException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
    }

    private void checkAppId(String appId) throws InvalidArgumentException {
        Arguments.checkThat((Object)appId).throwing(InvalidArgumentException.class).is(RequestAssertions.validApplicationId());
    }
}

