/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.maps.Maps;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.OrganizationRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Organization;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.aroma.thrift.exceptions.OrganizationDoesNotExistException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
final class MemoryOrganizationRepository
implements OrganizationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryOrganizationRepository.class);
    private final Map<String, Organization> organizations = Maps.createSynchronized();
    private final Map<String, Set<User>> members = Maps.createSynchronized();

    MemoryOrganizationRepository() {
    }

    @Override
    public void saveOrganization(Organization organization) throws TException {
        Arguments.checkThat((Object)organization).throwing(InvalidArgumentException.class).is(RequestAssertions.validOrganization());
        String orgId = organization.organizationId;
        this.organizations.put(orgId, organization);
    }

    @Override
    public Organization getOrganization(String organizationId) throws TException {
        Arguments.checkThat((Object)organizationId).throwing(InvalidArgumentException.class).is(RequestAssertions.validOrgId()).throwing(OrganizationDoesNotExistException.class).is(CollectionAssertions.keyInMap(this.organizations));
        return this.organizations.get(organizationId);
    }

    @Override
    public void deleteOrganization(String organizationId) throws TException {
        this.checkOrgId(organizationId);
        this.organizations.remove(organizationId);
    }

    @Override
    public boolean containsOrganization(String organizationId) throws TException {
        this.checkOrgId(organizationId);
        return this.organizations.containsKey(organizationId);
    }

    @Override
    public List<Organization> searchByName(String searchTerm) throws TException {
        Arguments.checkThat((Object)searchTerm).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        return this.organizations.values().stream().filter(org -> org.organizationName.contains(searchTerm)).collect(Collectors.toList());
    }

    @Override
    public List<User> getOrganizationOwners(String organizationId) throws TException {
        this.checkOrgId(organizationId);
        Organization org = this.getOrganization(organizationId);
        return Sets.copyOf((Collection)org.owners).stream().map(id -> new User().setUserId(id)).collect(Collectors.toList());
    }

    @Override
    public void saveMemberInOrganization(String organizationId, User user) throws TException {
        Arguments.checkThat((Object)organizationId).throwing(InvalidArgumentException.class).is(RequestAssertions.validOrgId()).throwing(OrganizationDoesNotExistException.class).is(CollectionAssertions.keyInMap(this.organizations));
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).is(RequestAssertions.validUser());
        Set<User> result = this.members.getOrDefault(organizationId, Sets.create());
        result.add(user);
        this.members.put(organizationId, result);
    }

    @Override
    public boolean isMemberInOrganization(String organizationId, String userId) throws TException {
        this.checkOrgId(organizationId);
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
        return this.members.getOrDefault(organizationId, Sets.emptySet()).stream().map(User::getUserId).anyMatch(id -> Objects.equals(id, userId));
    }

    @Override
    public List<User> getOrganizationMembers(String organizationId) throws TException {
        this.checkOrgId(organizationId);
        return this.members.getOrDefault(organizationId, Sets.emptySet()).stream().collect(Collectors.toList());
    }

    @Override
    public void deleteMember(String organizationId, String userId) throws TException {
        this.checkOrgId(organizationId);
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
        Set<Object> users = this.members.getOrDefault(organizationId, Sets.create());
        users = users.parallelStream().filter(user -> !Objects.equals(user.userId, userId)).collect(Collectors.toSet());
        this.members.put(organizationId, users);
    }

    @Override
    public void deleteAllMembers(String organizationId) throws TException {
        this.checkOrgId(organizationId);
        this.members.remove(organizationId);
    }

    private void checkOrgId(String organizationId) throws InvalidArgumentException {
        Arguments.checkThat((Object)organizationId).throwing(InvalidArgumentException.class).is(RequestAssertions.validOrgId());
    }
}

