/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.MediaRepository;
import tech.aroma.thrift.Dimension;
import tech.aroma.thrift.Image;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.Assertions;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.NumberAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
final class MemoryMediaRepository
implements MediaRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMediaRepository.class);
    private final Map<String, Image> images = Maps.createSynchronized();
    private final Map<String, Map<Dimension, Image>> thumbnails = Maps.createSynchronized();

    MemoryMediaRepository() {
    }

    @Override
    public void saveMedia(String mediaId, Image image) throws TException {
        this.checkMediaId(mediaId);
        this.checkImage(image);
        this.images.put(mediaId, image);
    }

    @Override
    public Image getMedia(String mediaId) throws DoesNotExistException, TException {
        this.checkMediaId(mediaId);
        this.checkExists(mediaId);
        return this.images.get(mediaId);
    }

    @Override
    public void deleteMedia(String mediaId) throws TException {
        this.checkMediaId(mediaId);
        this.images.remove(mediaId);
    }

    @Override
    public void saveThumbnail(String mediaId, Dimension dimension, Image thumbnail) throws TException {
        this.checkMediaId(mediaId);
        this.checkImage(thumbnail);
        this.checkDimension(dimension);
        Map<Dimension, Image> subThumbnails = this.thumbnails.getOrDefault(mediaId, Maps.createSynchronized());
        subThumbnails.put(dimension, thumbnail);
        this.thumbnails.put(mediaId, subThumbnails);
    }

    @Override
    public Image getThumbnail(String mediaId, Dimension dimension) throws DoesNotExistException, TException {
        this.checkMediaId(mediaId);
        this.checkDimension(dimension);
        Map<Dimension, Image> subThumbnails = this.thumbnails.getOrDefault(mediaId, Maps.create());
        Arguments.checkThat((Object)dimension).throwing(DoesNotExistException.class).usingMessage("Thumbnail does not exist").is(CollectionAssertions.keyInMap(subThumbnails));
        return subThumbnails.get(dimension);
    }

    @Override
    public void deleteThumbnail(String mediaId, Dimension dimension) throws TException {
        this.checkMediaId(mediaId);
        this.checkDimension(dimension);
        Map<Dimension, Image> subThumbnails = this.thumbnails.getOrDefault(mediaId, Maps.create());
        subThumbnails.remove(dimension);
        this.thumbnails.put(mediaId, subThumbnails);
    }

    @Override
    public void deleteAllThumbnails(String mediaId) throws TException {
        this.checkMediaId(mediaId);
        this.thumbnails.remove(mediaId);
    }

    private void checkImage(Image image) throws InvalidArgumentException {
        Arguments.checkThat((Object)image).throwing(InvalidArgumentException.class).usingMessage("image cannot be null").is(Assertions.notNull());
        Arguments.checkThat((Object)image.getData()).throwing(InvalidArgumentException.class).usingMessage("Image missing data").is(Assertions.notNull());
        Arguments.checkThat((Object)image.getData().length).throwing(InvalidArgumentException.class).usingMessage("Image data is empty").is(NumberAssertions.greaterThan((int)0));
        Arguments.checkThat((Object)image.imageType).throwing(InvalidArgumentException.class).usingMessage("Image missing Type").is(Assertions.notNull());
    }

    private void checkMediaId(String mediaId) throws InvalidArgumentException {
        Arguments.checkThat((Object)mediaId).throwing(InvalidArgumentException.class).usingMessage("mediaId missing").is(StringAssertions.nonEmptyString()).usingMessage("mediaId must be a UUID").is(StringAssertions.validUUID());
    }

    private void checkExists(String mediaId) throws DoesNotExistException, InvalidArgumentException {
        Arguments.checkThat((Object)mediaId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(DoesNotExistException.class).is(CollectionAssertions.keyInMap(this.images));
    }

    private void checkDimension(Dimension dimension) throws InvalidArgumentException {
        Arguments.checkThat((Object)dimension).usingMessage("dimension missing").is(Assertions.notNull());
        Arguments.checkThat((Object)dimension.width).usingMessage("dimension width must be > 0").throwing(InvalidArgumentException.class).is(NumberAssertions.greaterThan((int)0));
        Arguments.checkThat((Object)dimension.height).usingMessage("dimension height must be > 0").throwing(InvalidArgumentException.class).is(NumberAssertions.greaterThan((int)0));
    }
}

