/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.FollowerRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.User;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

final class MemoryFollowerRepository
implements FollowerRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryFollowerRepository.class);
    private final Map<String, List<Application>> userFollowings = Maps.createSynchronized();
    private final Map<String, List<User>> applicationFollowers = Maps.createSynchronized();

    MemoryFollowerRepository() {
    }

    @Override
    public void saveFollowing(User user, Application application) throws TException {
        Arguments.checkThat((Object)user).throwing(InvalidArgumentException.class).is(RequestAssertions.validUser());
        Arguments.checkThat((Object)application).throwing(InvalidArgumentException.class).is(RequestAssertions.validApplication());
        String userId = user.userId;
        String appId = application.applicationId;
        List<Application> applications = this.userFollowings.getOrDefault(userId, Lists.create());
        applications.add(application);
        this.userFollowings.put(userId, applications);
        List<User> followers = this.applicationFollowers.getOrDefault(appId, Lists.create());
        followers.add(user);
        this.applicationFollowers.put(appId, followers);
    }

    @Override
    public void deleteFollowing(String userId, String applicationId) throws TException {
        Arguments.checkThat((Object)userId, (Object[])new String[]{applicationId}).throwing(InvalidArgumentException.class).are(StringAssertions.nonEmptyString());
        List<Object> apps = this.userFollowings.getOrDefault(userId, Lists.emptyList());
        apps = apps.stream().filter(app -> !Objects.equal((Object)applicationId, (Object)app.applicationId)).collect(Collectors.toList());
        this.userFollowings.put(userId, apps);
        List<Object> followers = this.applicationFollowers.getOrDefault(applicationId, Lists.emptyList());
        followers = followers.stream().filter(user -> !Objects.equal((Object)userId, (Object)user.userId)).collect(Collectors.toList());
        this.applicationFollowers.put(applicationId, followers);
    }

    @Override
    public boolean followingExists(String userId, String applicationId) throws TException {
        Arguments.checkThat((Object)userId, (Object[])new String[]{applicationId}).throwing(InvalidArgumentException.class).usingMessage("missing arguments").are(StringAssertions.nonEmptyString());
        return this.userFollowsApp(userId, applicationId) && this.appHasFollower(applicationId, userId);
    }

    @Override
    public List<Application> getApplicationsFollowedBy(String userId) throws TException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).usingMessage("missing userId").is(StringAssertions.nonEmptyString());
        return this.userFollowings.getOrDefault(userId, Lists.emptyList());
    }

    @Override
    public List<User> getApplicationFollowers(String applicationId) throws TException {
        return this.applicationFollowers.getOrDefault(applicationId, Lists.emptyList());
    }

    private boolean userFollowsApp(String userId, String applicationId) {
        List<Application> apps = this.userFollowings.get(userId);
        if (Lists.isEmpty(apps)) {
            return false;
        }
        return apps.stream().anyMatch(app -> Objects.equal((Object)applicationId, (Object)app.applicationId));
    }

    private boolean appHasFollower(String applicationId, String userId) {
        List<User> followers = this.applicationFollowers.get(applicationId);
        if (Lists.isEmpty(followers)) {
            return false;
        }
        return followers.stream().anyMatch(user -> Objects.equal((Object)userId, (Object)user.userId));
    }
}

