/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.Map;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.maps.Maps;
import tech.aroma.data.CredentialRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.exceptions.DoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

@Internal
final class MemoryCredentialsRepository
implements CredentialRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryCredentialsRepository.class);
    private final Map<String, String> passwords = Maps.createSynchronized();

    MemoryCredentialsRepository() {
    }

    @Override
    public void saveEncryptedPassword(String userId, String encryptedPassword) throws TException {
        this.checkUserId(userId);
        this.checkPassword(encryptedPassword);
        this.passwords.put(userId, encryptedPassword);
    }

    @Override
    public boolean containsEncryptedPassword(String userId) throws TException {
        this.checkUserId(userId);
        return this.passwords.containsKey(userId);
    }

    @Override
    public String getEncryptedPassword(String userId) throws TException {
        this.checkUserId(userId);
        Arguments.checkThat((Object)userId).throwing(DoesNotExistException.class).is(CollectionAssertions.keyInMap(this.passwords));
        return this.passwords.get(userId);
    }

    @Override
    public void deleteEncryptedPassword(String userId) throws TException {
        this.checkUserId(userId);
        this.passwords.remove(userId);
    }

    private void checkPassword(String encryptedPassword) throws InvalidArgumentException {
        Arguments.checkThat((Object)encryptedPassword).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
    }

    private void checkUserId(String userId) throws InvalidArgumentException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(RequestAssertions.validUserId());
    }
}

