/*
 * Decompiled with CFR 0.152.
 */
package tech.aroma.data.memory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sir.wellington.alchemy.collections.lists.Lists;
import sir.wellington.alchemy.collections.maps.Maps;
import sir.wellington.alchemy.collections.sets.Sets;
import tech.aroma.data.ApplicationRepository;
import tech.aroma.data.assertions.RequestAssertions;
import tech.aroma.thrift.Application;
import tech.aroma.thrift.exceptions.ApplicationDoesNotExistException;
import tech.aroma.thrift.exceptions.InvalidArgumentException;
import tech.sirwellington.alchemy.arguments.Arguments;
import tech.sirwellington.alchemy.arguments.assertions.CollectionAssertions;
import tech.sirwellington.alchemy.arguments.assertions.StringAssertions;

final class MemoryApplicationRepository
implements ApplicationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryApplicationRepository.class);
    private final Map<String, Application> mainTable = Maps.create();
    private final Map<String, Set<Application>> applicationsByOrg = Maps.create();
    private final ExpiringMap<String, Application> recents = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();

    MemoryApplicationRepository() {
    }

    @Override
    public void saveApplication(Application application) throws TException {
        Arguments.checkThat((Object)application).throwing(InvalidArgumentException.class).is(RequestAssertions.validApplication());
        String applicationId = application.applicationId;
        this.mainTable.put(applicationId, application);
        this.recents.put((Object)applicationId, (Object)application);
        if (!RequestAssertions.isNullOrEmpty(application.organizationId)) {
            Set<Application> applications = this.applicationsByOrg.getOrDefault(applicationId, Sets.create());
            applications.add(application);
            this.applicationsByOrg.put(applicationId, applications);
        }
    }

    @Override
    public boolean containsApplication(String applicationId) throws TException {
        return this.mainTable.containsKey(applicationId);
    }

    @Override
    public void deleteApplication(String applicationId) throws TException {
        this.checkIdExists(applicationId);
        this.mainTable.remove(applicationId);
        this.applicationsByOrg.remove(applicationId);
        this.recents.remove((Object)applicationId);
    }

    @Override
    public Application getById(String applicationId) throws TException {
        this.checkIdExists(applicationId);
        return this.mainTable.get(applicationId);
    }

    @Override
    public List<Application> getApplicationsOwnedBy(String userId) throws TException {
        Arguments.checkThat((Object)userId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        return this.mainTable.values().stream().filter(app -> app.isSetOwners()).filter(this.containsOwner(userId)).collect(Collectors.toList());
    }

    @Override
    public List<Application> getApplicationsByOrg(String orgId) throws TException {
        Arguments.checkThat((Object)orgId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString());
        Set<Application> applications = this.applicationsByOrg.getOrDefault(orgId, Sets.emptySet());
        return Lists.toList(applications);
    }

    @Override
    public List<Application> searchByName(String searchTerm) throws TException {
        return this.mainTable.values().stream().filter(this.containsInName(searchTerm)).collect(Collectors.toList());
    }

    @Override
    public List<Application> getRecentlyCreated() throws TException {
        return Lists.toList((Collection)this.recents.values());
    }

    private void checkIdExists(String applicationId) throws TException {
        Arguments.checkThat((Object)applicationId).throwing(InvalidArgumentException.class).is(StringAssertions.nonEmptyString()).throwing(ApplicationDoesNotExistException.class).usingMessage("application does not exist").is(CollectionAssertions.keyInMap(this.mainTable));
    }

    private Predicate<Application> containsOwner(String userId) {
        return app -> {
            if (Lists.isEmpty((Collection)app.owners)) {
                return false;
            }
            return app.owners.stream().filter(user -> !RequestAssertions.isNullOrEmpty(user)).filter(user -> user.equals(userId)).count() > 0L;
        };
    }

    private Predicate<? super Application> containsInName(String searchTerm) {
        return app -> {
            if (RequestAssertions.isNullOrEmpty(app.name)) {
                return false;
            }
            return app.name.contains(searchTerm);
        };
    }
}

